/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.xsd.validation.error;

import java.io.PrintWriter;
import repackage.org.xml.sax.ErrorHandler;
import repackage.org.xml.sax.SAXException;
import repackage.org.xml.sax.SAXParseException;

public abstract class SimpleErrorHandler
implements ErrorHandler {
    private PrintWriter out;
    private boolean failOnError;

    protected SimpleErrorHandler(PrintWriter out, boolean failOnError) {
        this.out = out;
        this.failOnError = failOnError;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.printException("Warning", e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.printException("Error", e);
        if (this.failOnError) {
            throw e;
        }
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.printException("Fatal error", e);
        if (this.failOnError) {
            throw e;
        }
    }

    private void printException(String prefix, SAXParseException e) {
        this.out.format("[%s] line:%d column:%d: %s%n", prefix, e.getLineNumber(), e.getColumnNumber(), e.getMessage());
    }
}

