/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.xsd.validation;

import com.qubit.terra.xsd.validation.error.FailFastErrorHandler;
import com.qubit.terra.xsd.validation.error.FailSlowErrorHandler;
import com.qubit.terra.xsd.validation.error.SimpleErrorHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import repackage.javax.xml.transform.stream.StreamSource;
import repackage.javax.xml.validation.Schema;
import repackage.javax.xml.validation.SchemaFactory;
import repackage.javax.xml.validation.Validator;
import repackage.org.apache.xerces.jaxp.validation.BaseSchemaFactory;
import repackage.org.apache.xerces.jaxp.validation.XMLSchema11Factory;
import repackage.org.apache.xerces.jaxp.validation.XMLSchemaFactory;

public class XSDValidator {
    public static final String XSD_10 = "http://www.w3.org/XML/XMLSchema/v1.0";
    public static final String XSD_11 = "http://www.w3.org/XML/XMLSchema/v1.1";
    private boolean failFast;

    public static void main(String[] args) throws FileNotFoundException {
        XSDValidator xsdValidator = new XSDValidator(false);
        System.out.print(xsdValidator.validate(new FileInputStream(new File(args[0])), new FileInputStream(new File(args[1])), args[2]));
    }

    public XSDValidator(boolean failFast) {
        this.failFast = failFast;
    }

    public String validate(InputStream xsd, InputStream xml, String schemaLanguage) {
        StringWriter writer = new StringWriter();
        SimpleErrorHandler errorHandler = this.failFast ? new FailFastErrorHandler(new PrintWriter(writer)) : new FailSlowErrorHandler(new PrintWriter(writer));
        try {
            BaseSchemaFactory schemaFactory = null;
            switch (schemaLanguage) {
                case "http://www.w3.org/XML/XMLSchema/v1.0": {
                    schemaFactory = new XMLSchemaFactory();
                    break;
                }
                case "http://www.w3.org/XML/XMLSchema/v1.1": {
                    schemaFactory = new XMLSchema11Factory();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Received schemaLanguage: " + schemaLanguage + " but currently we only support: http://www.w3.org/XML/XMLSchema/v1.0 and http://www.w3.org/XML/XMLSchema/v1.1");
                }
            }
            ((SchemaFactory)schemaFactory).setErrorHandler(errorHandler);
            Schema schema = schemaFactory.newSchema(new StreamSource(xsd));
            Validator validator = schema.newValidator();
            validator.setErrorHandler(errorHandler);
            validator.validate(new StreamSource(xml));
            return writer.toString();
        }
        catch (Throwable t) {
            return t.getMessage();
        }
    }

    static {
        System.setProperty("repackage/javax.xml.validation.SchemaFactory:http://www.w3.org/XML/XMLSchema/v1.1", "repackage.org.apache.xerces.jaxp.validation.XMLSchema11Factory");
        System.setProperty("repackage/javax.xml.validation.SchemaFactory:http://www.w3.org/XML/XMLSchema/v1.0", "repackage.org.apache.xerces.jaxp.validation.XMLSchemaFactory");
    }
}

