/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.docs.core;

import com.qubit.terra.docs.core.DocumentTemplateEngine;
import com.qubit.terra.docs.core.IDocumentTemplate;
import com.qubit.terra.docs.util.IReportDataProvider;
import com.qubit.terra.docs.util.ReportGenerationException;
import com.qubit.terra.docs.util.ReportGenerator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DocumentGenerator
extends ReportGenerator {
    protected DocumentGenerator(IDocumentTemplate documentTemplate, String mimeType) {
        this(documentTemplate.getCurrentVersion().getContent(), mimeType);
    }

    protected DocumentGenerator(byte[] template, String mimeType) {
        super(template, DocumentTemplateEngine.getServiceImplementation().getFontsPath(), mimeType);
    }

    public DocumentGenerator registerDataProviders(Collection<? extends IReportDataProvider> providers) {
        for (IReportDataProvider iReportDataProvider : providers) {
            this.registerDataProvider(iReportDataProvider);
        }
        return this;
    }

    public static DocumentGenerator create(IDocumentTemplate documentTemplate, String mimeType) {
        return new DocumentGenerator(documentTemplate, mimeType);
    }

    public static DocumentGenerator create(String template, String mimeType) {
        try {
            return new DocumentGenerator(FileUtils.readFileToByteArray((File)new File(template)), mimeType);
        }
        catch (FileNotFoundException e) {
            throw new ReportGenerationException("Error finding template", e);
        }
        catch (IOException e) {
            throw new ReportGenerationException("Error finding template", e);
        }
    }

    public static DocumentGenerator create(InputStream inputStream, String mimeType) {
        try {
            return new DocumentGenerator(IOUtils.toByteArray((InputStream)inputStream), mimeType);
        }
        catch (IOException e) {
            throw new ReportGenerationException("Error finding template", e);
        }
    }
}

