/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.docs.util.processors.post;

import com.qubit.terra.docs.util.helpers.OpenofficeInProcessConverter;
import com.qubit.terra.docs.util.processors.post.ReportGeneratorPostProcessor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.TextDocument;
import org.odftoolkit.simple.common.field.Fields;
import org.odftoolkit.simple.table.Cell;
import org.odftoolkit.simple.table.Row;
import org.odftoolkit.simple.table.Table;
import org.odftoolkit.simple.text.Paragraph;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdtTablePostProcessor
extends ReportGeneratorPostProcessor {
    public static final Pattern PATTERN = Pattern.compile("\\$\\$qub(.+)-(\\d+)");
    public static final String PAGE_ANCHOR = "$$qub";
    protected static String TABLE_COLUMN_NODE_NAME = "table:table-column";
    protected static String TABLE_HEADER_ROWS_NODE_NAME = "table:table-header-rows";
    protected static String TABLE_ROW_NODE_NAME = "table:table-row";
    protected static String SOFT_PAGE_BREAK_NODE_NAME = "text:soft-page-break";
    protected static String TEXT_NOTE_NODE_NAME = "text:note";
    protected static String TEXT_PARAGRAPH_NODE_NAME = "text:p";

    @Override
    protected void visit() {
        Document copiedDocument = null;
        ByteArrayOutputStream copiedByteArrayStream = null;
        try {
            ArrayList<String> tableNames = new ArrayList<String>();
            byte[] copiedByteArray = this.save();
            copiedDocument = Document.loadDocument((InputStream)new ByteArrayInputStream(copiedByteArray));
            for (Table table : copiedDocument.getTableList()) {
                int numberOfRows = Integer.min(table.getRowCount(), 3);
                for (int i = 1; i <= numberOfRows; ++i) {
                    Row row = table.getRowByIndex(table.getRowCount() - i);
                    Paragraph paragraph = this.getOrCreateParagraph(row, PAGE_ANCHOR + table.getTableName() + "-");
                    Fields.createCurrentPageNumberField((OdfElement)paragraph.getOdfElement());
                }
            }
            String property = "java.io.tmpdir";
            String tempDir = System.getProperty(property);
            copiedByteArrayStream = new ByteArrayOutputStream();
            copiedDocument.save((OutputStream)copiedByteArrayStream);
            copiedByteArray = OpenofficeInProcessConverter.convert(copiedByteArrayStream.toByteArray(), "odt", tempDir, "pdf");
            tableNames.addAll(this.processPdf(copiedByteArray));
            this.processTables(tableNames);
        }
        catch (Exception e) {
            throw new RuntimeException("Error in visiting Odf Document. " + e.getMessage());
        }
        finally {
            if (copiedDocument != null) {
                copiedDocument.close();
            }
            if (copiedByteArrayStream != null) {
                try {
                    copiedByteArrayStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> processPdf(byte[] pdfContent) {
        ArrayList<String> tablesToProcess = new ArrayList<String>();
        PDDocument pdfDoc = null;
        try {
            HashMap<String, HashSet<Integer>> verifyTablesSplit = new HashMap<String, HashSet<Integer>>();
            pdfDoc = PDDocument.load((byte[])pdfContent);
            PDFTextStripper pdfStripper = new PDFTextStripper();
            String text = pdfStripper.getText(pdfDoc);
            Matcher matcher = PATTERN.matcher(text);
            while (matcher.find()) {
                HashSet<Integer> lst = (HashSet<Integer>)verifyTablesSplit.get(matcher.group(1));
                if (lst == null) {
                    lst = new HashSet<Integer>();
                }
                lst.add(Integer.valueOf(matcher.group(2)));
                verifyTablesSplit.put(matcher.group(1), lst);
            }
            for (Map.Entry entry : verifyTablesSplit.entrySet()) {
                String tableName = (String)entry.getKey();
                Set rowsPageNumber = (Set)entry.getValue();
                if (rowsPageNumber.size() == 1) continue;
                tablesToProcess.add(tableName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (pdfDoc != null) {
                try {
                    pdfDoc.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return tablesToProcess;
    }

    protected void processTables(List<String> tableNames) {
        for (TableTableElement table : this.document.getTables()) {
            if (!tableNames.contains(table.getTableNameAttribute())) continue;
            NodeList childList = table.getChildNodes();
            if (childList.getLength() > 3) {
                this.splitTable(table, childList.getLength() - 4);
                continue;
            }
            System.out.println("[WARN] Document has a table, " + table.getTableNameAttribute() + ", with less than five rows and they are splitted! Check this situation");
        }
    }

    private void splitTable(TableTableElement originalTable, int breakIndex) {
        TableTableElement copiedTable = (TableTableElement)((TextDocument)this.document).insertOdfElement((OdfElement)originalTable, this.document, (OdfElement)originalTable, false);
        this.processOriginalTable(originalTable, breakIndex);
        this.processCopiedTable(copiedTable, breakIndex);
    }

    private void processOriginalTable(TableTableElement originalTable, int breakIndex) {
        NodeList childList = originalTable.getChildNodes();
        ArrayList<Node> childsToRemove = new ArrayList<Node>();
        for (int i = breakIndex; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            if (!child.getNodeName().equals(TABLE_ROW_NODE_NAME) && !child.getNodeName().equals(SOFT_PAGE_BREAK_NODE_NAME)) continue;
            childsToRemove.add(child);
        }
        for (Node node : childsToRemove) {
            originalTable.removeChild(node);
        }
    }

    private void processCopiedTable(TableTableElement copiedTable, int breakIndex) {
        NodeList childList = copiedTable.getChildNodes();
        ArrayList<Node> childsToRemove = new ArrayList<Node>();
        for (int i = 0; i < childList.getLength(); ++i) {
            Node child = childList.item(i);
            if (child.getNodeName().equals(TABLE_COLUMN_NODE_NAME)) continue;
            if (child.getNodeName().equals(TABLE_HEADER_ROWS_NODE_NAME)) {
                this.deleteFootNotes(child);
                continue;
            }
            if (child.getNodeName().equals(TABLE_ROW_NODE_NAME) && i < breakIndex) {
                childsToRemove.add(child);
                continue;
            }
            if (!child.getNodeName().equals(SOFT_PAGE_BREAK_NODE_NAME)) continue;
            childsToRemove.add(child);
        }
        OdfStyle copiedTableStyle = (OdfStyle)copiedTable.getAutomaticStyle().cloneNode(true);
        copiedTableStyle.setStyleNameAttribute(copiedTableStyle.getStyleNameAttribute() + "Clone2");
        copiedTable.getAutomaticStyles().appendChild((Node)copiedTableStyle);
        copiedTable.setStyleName(copiedTableStyle.getStyleNameAttribute());
        OdfStyleProperty breakPageProperty = OdfStyleProperty.get((OdfStylePropertiesSet)OdfStylePropertiesSet.TableProperties, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.FO, (String)"break-before"));
        copiedTableStyle.setProperty(breakPageProperty, "page");
        for (Node node : childsToRemove) {
            copiedTable.removeChild(node);
        }
    }

    private void deleteFootNotes(Node node) {
        NodeList childNodes = node.getChildNodes();
        ArrayList<Node> childToRemove = new ArrayList<Node>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeName().equals(TEXT_NOTE_NODE_NAME)) {
                childToRemove.add(child);
                continue;
            }
            this.deleteFootNotes(child);
        }
        for (Node child : childToRemove) {
            node.removeChild(child);
        }
    }

    private Paragraph getOrCreateParagraph(Row row, String prefix) {
        Paragraph p;
        Cell cell = row.getCellByIndex(0);
        if (cell.getParagraphIterator().hasNext()) {
            p = (Paragraph)cell.getParagraphIterator().next();
            String content = p.getTextContent();
            String styleName = p.getStyleName();
            cell.removeParagraph(p);
            int sizeDifference = content.length() - prefix.length() - 1;
            p = sizeDifference > 0 ? cell.addParagraph(content.substring(0, content.length() - prefix.length()) + prefix) : cell.addParagraph(prefix);
            p.setStyleName(styleName);
        } else {
            p = cell.addParagraph(prefix);
        }
        return p;
    }
}

