/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.docs.util.helpers;

import com.qubit.terra.docs.util.helpers.OpenofficeInProcessConversionException;
import java.io.File;
import org.apache.commons.io.FileUtils;

public class OpenofficeInProcessConverter {
    private static final long ELAPSE_TIME = 2000L;

    public static synchronized byte[] convert(byte[] fileContent, String fileExtension, String tempDirFullPath, String mimeTypeAbbreviation) {
        try {
            long currentTimeMillis = System.currentTimeMillis();
            if (System.getProperty("os.name").startsWith("Windows")) {
                String fileName = tempDirFullPath + "openofficeConversion-" + currentTimeMillis + "." + fileExtension;
                FileUtils.writeByteArrayToFile((File)new File(fileName), (byte[])fileContent);
                Process process = Runtime.getRuntime().exec(String.format("soffice --headless --convert-to %s --outdir %s %s", mimeTypeAbbreviation, tempDirFullPath.subSequence(0, tempDirFullPath.length() - 1), fileName));
                try {
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                process.destroy();
                String outputFilename = tempDirFullPath + "openofficeConversion-" + currentTimeMillis + "." + mimeTypeAbbreviation;
                byte[] output = FileUtils.readFileToByteArray((File)new File(outputFilename));
                FileUtils.deleteQuietly((File)new File(fileName));
                FileUtils.deleteQuietly((File)new File(outputFilename));
                return output;
            }
            File inputDir = new File(tempDirFullPath + "/documents-" + currentTimeMillis);
            inputDir.mkdir();
            String fileName = tempDirFullPath + "/documents-" + currentTimeMillis + "/openofficeConversion-" + currentTimeMillis + "." + fileExtension;
            FileUtils.writeByteArrayToFile((File)new File(fileName), (byte[])fileContent);
            Process process = Runtime.getRuntime().exec(String.format("soffice --headless --convert-to %s -env:UserInstallation=file://%s --outdir %s %s", mimeTypeAbbreviation, tempDirFullPath, tempDirFullPath, fileName));
            try {
                process.waitFor();
            }
            catch (InterruptedException output) {
                // empty catch block
            }
            process.destroy();
            String outputFilename = tempDirFullPath + "/openofficeConversion-" + currentTimeMillis + "." + mimeTypeAbbreviation;
            byte[] output = FileUtils.readFileToByteArray((File)new File(outputFilename));
            FileUtils.deleteQuietly((File)inputDir);
            FileUtils.deleteQuietly((File)new File(outputFilename));
            return output;
        }
        catch (Throwable e) {
            throw new OpenofficeInProcessConversionException(e);
        }
    }
}

