/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.docs.util.converters;

import com.qubit.terra.docs.util.FontProvider;
import com.qubit.terra.docs.util.IReportConverter;
import com.qubit.terra.docs.util.ReportGenerationException;
import fr.opensagres.xdocreport.itext.extension.font.IFontProvider;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.odftoolkit.odfdom.converter.core.Options;
import org.odftoolkit.odfdom.converter.pdf.PdfConverter;
import org.odftoolkit.odfdom.converter.pdf.PdfOptions;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;

public class OdtToPdfReportConverter
implements IReportConverter {
    private FontProvider fontProvider = FontProvider.create();

    public OdtToPdfReportConverter(String fontDirectory) {
    }

    @Override
    public boolean convertFromType(String mimeType) {
        return "application/vnd.oasis.opendocument.text".equals(mimeType);
    }

    @Override
    public boolean isForType(String mimeType) {
        return "application/pdf".equals(mimeType);
    }

    @Override
    public byte[] convert(InputStream document) {
        try {
            OdfTextDocument odfDocument = OdfTextDocument.loadDocument((InputStream)document);
            PdfOptions options = PdfOptions.getDefault();
            options.fontProvider((IFontProvider)this.fontProvider);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            PdfConverter.getInstance().convert((OdfDocument)odfDocument, (OutputStream)result, (Options)options);
            return result.toByteArray();
        }
        catch (Exception e) {
            throw new ReportGenerationException("Error converting the report", e);
        }
    }
}

