/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.docs.util;

import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import com.qubit.terra.docs.util.FontManager;
import fr.opensagres.xdocreport.itext.extension.font.IFontProvider;
import fr.opensagres.xdocreport.utils.StringUtils;
import java.awt.Color;

public class FontProvider
implements IFontProvider {
    protected FontManager fontManager = FontManager.sharedInstance();

    protected FontProvider() {
    }

    public Font getFont(String familyName, String encoding, float size, int style, Color color) {
        try {
            BaseFont baseFont = this.fontManager.findBaseFont(familyName, style);
            Font font = new Font(baseFont, size, style, color);
            if (!StringUtils.isEmpty((String)familyName)) {
                font.setFamily(familyName);
            }
            return font;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return FontFactory.getFont((String)familyName, (String)encoding, (float)size, (int)style, (Color)color);
        }
    }

    public static FontProvider create() {
        return new FontProvider();
    }
}

