/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.docs.core;

import com.qubit.terra.docs.core.DocumentGenerator;
import com.qubit.terra.docs.core.IDocumentTemplate;
import com.qubit.terra.docs.core.IDocumentTemplateService;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.util.Collection;

public class DocumentTemplateEngine {
    private static IDocumentTemplateService documentTemplateService;

    public static void registerServiceImplementations(IDocumentTemplateService service) {
        documentTemplateService = service;
    }

    public static IDocumentTemplateService getServiceImplementation() {
        return documentTemplateService;
    }

    public DocumentGenerator createGeneratorForDocx(IDocumentTemplate template, Collection<? extends IReportDataProvider> dataProviders) {
        return this.createGenerator(template, dataProviders, "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
    }

    public DocumentGenerator createGeneratorForPdf(IDocumentTemplate template, Collection<? extends IReportDataProvider> dataProviders) {
        return this.createGenerator(template, dataProviders, "application/pdf");
    }

    public DocumentGenerator createGenerator(IDocumentTemplate template, Collection<? extends IReportDataProvider> dataProviders, String mimeTypeFormat) {
        DocumentGenerator documentGenerator = DocumentGenerator.create(template, mimeTypeFormat);
        documentGenerator.registerDataProviders(dataProviders);
        return documentGenerator;
    }
}

