/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.docs.util.processors.post;

import com.qubit.terra.docs.util.processors.post.ReportGeneratorPostProcessor;
import java.util.ArrayList;
import java.util.List;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.text.TextNoteElement;
import org.odftoolkit.odfdom.dom.element.text.TextParagraphElementBase;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.pkg.NamespaceName;
import org.odftoolkit.odfdom.pkg.OdfName;
import org.odftoolkit.simple.TextDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OdtFootEndNotePostProcessor
extends ReportGeneratorPostProcessor {
    protected static String TABLE_COLUMN_NODE_NAME = "table:table-column";
    protected static String TABLE_HEADER_ROWS_NODE_NAME = "table:table-header-rows";
    protected static String TABLE_ROW_NODE_NAME = "table:table-row";
    protected static String SOFT_PAGE_BREAK_NODE_NAME = "text:soft-page-break";
    protected static String TEXT_NOTE_NODE_NAME = "text:note";
    protected static String TEXT_PARAGRAPH_NODE_NAME = "text:p";
    protected Boolean alignRight;

    public OdtFootEndNotePostProcessor(Boolean alignLeft) {
        this.alignRight = alignLeft;
    }

    @Override
    protected void visit() {
        try {
            if (this.alignRight != null && this.alignRight.booleanValue()) {
                this.visitFooter();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void visitFootNotes() {
        block0: for (TableTableElement table : this.document.getTables()) {
            NodeList childList = table.getChildNodes();
            for (int i = 0; i < childList.getLength(); ++i) {
                Node child = childList.item(i);
                if (!child.getNodeName().equals(TABLE_HEADER_ROWS_NODE_NAME)) continue;
                List<TextNoteElement> footNotes = this.findFootNotes(child);
                this.processFootNotes(footNotes);
                continue block0;
            }
        }
    }

    private void processFootNotes(List<TextNoteElement> footNotes) {
        ArrayList<TextParagraphElementBase> paragraphs = new ArrayList<TextParagraphElementBase>();
        for (TextNoteElement footNote : footNotes) {
            paragraphs.addAll(this.findParagraphs((Node)footNote));
        }
        for (TextParagraphElementBase paragraph : paragraphs) {
            OdfStyleProperty marginLeftProperty = OdfStyleProperty.get((OdfStylePropertiesSet)OdfStylePropertiesSet.ParagraphProperties, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.FO, (String)"margin-left"));
            OdfStyleProperty marginRightProperty = OdfStyleProperty.get((OdfStylePropertiesSet)OdfStylePropertiesSet.ParagraphProperties, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.FO, (String)"margin-right"));
            OdfStyleProperty textIndentProperty = OdfStyleProperty.get((OdfStylePropertiesSet)OdfStylePropertiesSet.ParagraphProperties, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.FO, (String)"text-indent"));
            OdfStyleProperty textAutoIndentProperty = OdfStyleProperty.get((OdfStylePropertiesSet)OdfStylePropertiesSet.ParagraphProperties, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.FO, (String)"auto-text-indent"));
            OdfStyleProperty writingModeProperty = OdfStyleProperty.get((OdfStylePropertiesSet)OdfStylePropertiesSet.ParagraphProperties, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.FO, (String)"writing-mode"));
            paragraph.getAutomaticStyle().setProperty(marginLeftProperty, "9.999cm");
            paragraph.getAutomaticStyle().setProperty(marginRightProperty, "0cm");
            paragraph.getAutomaticStyle().setProperty(textIndentProperty, "-0.6cm");
            paragraph.getAutomaticStyle().setProperty(textAutoIndentProperty, "false");
            paragraph.getAutomaticStyle().setProperty(writingModeProperty, "page");
        }
    }

    private List<TextNoteElement> findFootNotes(Node node) {
        NodeList childNodes = node.getChildNodes();
        ArrayList<TextNoteElement> result = new ArrayList<TextNoteElement>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeName().equals(TEXT_NOTE_NODE_NAME)) {
                TextNoteElement element = (TextNoteElement)child;
                OdfName noteClassAttribute = OdfName.newName((NamespaceName)OdfDocumentNamespace.TEXT, (String)"note-class");
                if (!element.hasOdfAttribute(noteClassAttribute) || !element.getOdfAttribute(noteClassAttribute).getValue().equals("footnote")) continue;
                result.add(element);
                continue;
            }
            result.addAll(this.findFootNotes(child));
        }
        return result;
    }

    private List<TextParagraphElementBase> findParagraphs(Node node) {
        NodeList childNodes = node.getChildNodes();
        ArrayList<TextParagraphElementBase> result = new ArrayList<TextParagraphElementBase>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (child.getNodeName().equals(TEXT_PARAGRAPH_NODE_NAME)) {
                TextParagraphElementBase element = (TextParagraphElementBase)child;
                result.add(element);
                continue;
            }
            result.addAll(this.findParagraphs(child));
        }
        return result;
    }

    private void visitEndNotes() {
    }

    private void visitFooter() throws Exception {
        int i;
        ArrayList<TextParagraphElementBase> paragraphs = new ArrayList<TextParagraphElementBase>();
        NodeList footersList = ((TextDocument)this.document).getStylesDom().getElementsByTagName("style:footer");
        if (footersList != null) {
            for (i = 0; i < footersList.getLength(); ++i) {
                paragraphs.addAll(this.findParagraphs(footersList.item(i)));
            }
        }
        if ((footersList = ((TextDocument)this.document).getStylesDom().getElementsByTagName("style:footer-first")) != null) {
            for (i = 0; i < footersList.getLength(); ++i) {
                paragraphs.addAll(this.findParagraphs(footersList.item(i)));
            }
        }
        for (TextParagraphElementBase paragraph : paragraphs) {
            OdfStyleProperty textAlignProperty = OdfStyleProperty.get((OdfStylePropertiesSet)OdfStylePropertiesSet.ParagraphProperties, (OdfName)OdfName.newName((NamespaceName)OdfDocumentNamespace.FO, (String)"text-align"));
            String textAlignValue = (String)paragraph.getAutomaticStyle().getStylePropertiesDeep().get(textAlignProperty);
            if (textAlignValue != null && textAlignValue.equals("center")) {
                paragraph.getAutomaticStyle().setProperty(textAlignProperty, "right");
                continue;
            }
            if (textAlignValue != null && !textAlignValue.equals("right")) continue;
        }
    }
}

