/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.docs.util.converters;

import com.qubit.terra.docs.util.IReportConverter;
import com.qubit.terra.docs.util.ReportGenerationException;
import com.qubit.terra.docs.util.helpers.OpenofficeInProcessConverter;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class OdtToPdfOpenofficeConverter
implements IReportConverter {
    @Override
    public boolean convertFromType(String mimeType) {
        return "application/vnd.oasis.opendocument.text".equals(mimeType);
    }

    @Override
    public boolean isForType(String mimeType) {
        return "application/pdf".equals(mimeType);
    }

    @Override
    public byte[] convert(InputStream document) {
        try {
            String property = "java.io.tmpdir";
            String tempDir = System.getProperty(property);
            return OpenofficeInProcessConverter.convert(IOUtils.toByteArray((InputStream)document), "odt", tempDir, "pdf");
        }
        catch (Exception e) {
            throw new ReportGenerationException("Error converting the report", e);
        }
    }
}

