/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.docs.util.converters;

import com.qubit.terra.docs.util.FontProvider;
import com.qubit.terra.docs.util.IReportConverter;
import com.qubit.terra.docs.util.ReportGenerationException;
import fr.opensagres.xdocreport.itext.extension.font.IFontProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.xwpf.converter.core.Options;
import org.apache.poi.xwpf.converter.pdf.PdfConverter;
import org.apache.poi.xwpf.converter.pdf.PdfOptions;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class DocxToPdfReportConverter
implements IReportConverter {
    private FontProvider fontProvider = FontProvider.create();

    public DocxToPdfReportConverter(String fontDirectory) {
    }

    @Override
    public boolean isForType(String mimeType) {
        return "application/pdf".equals(mimeType);
    }

    @Override
    public byte[] convert(InputStream document) {
        try {
            XWPFDocument xWPFDocument = new XWPFDocument(document);
            PdfOptions options = PdfOptions.getDefault();
            options.fontProvider((IFontProvider)this.fontProvider);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            PdfConverter.getInstance().convert(xWPFDocument, (OutputStream)result, (Options)options);
            return result.toByteArray();
        }
        catch (IOException e) {
            throw new ReportGenerationException("Error converting the report", e);
        }
    }

    @Override
    public boolean convertFromType(String mimeType) {
        return "application/vnd.openxmlformats-officedocument.wordprocessingml.document".equals(mimeType);
    }
}

