/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.docs.util;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfCopyFields;
import com.lowagie.text.pdf.PdfReader;
import com.qubit.terra.docs.core.DocumentTemplateEngine;
import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportConverter;
import com.qubit.terra.docs.util.IReportDataProvider;
import com.qubit.terra.docs.util.ReportGenerationException;
import com.qubit.terra.docs.util.converters.DocxToDocxReportConverter;
import com.qubit.terra.docs.util.converters.DocxToPdfReportConverter;
import com.qubit.terra.docs.util.converters.OdtToDocxOpenofficeConverter;
import com.qubit.terra.docs.util.converters.OdtToOdtReportConverter;
import com.qubit.terra.docs.util.converters.OdtToPdfOpenofficeConverter;
import com.qubit.terra.docs.util.converters.OdtToPdfReportConverter;
import com.qubit.terra.docs.util.helpers.IDocumentHelper;
import com.qubit.terra.docs.util.processors.post.ReportGeneratorPostProcessor;
import com.qubit.terra.docs.util.processors.pre.ReportGeneratorPreProcessor;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.XDocReport;
import fr.opensagres.xdocreport.document.dispatcher.AbstractXDocReportController;
import fr.opensagres.xdocreport.document.dispatcher.IXDocReportController;
import fr.opensagres.xdocreport.document.images.ByteArrayImageProvider;
import fr.opensagres.xdocreport.document.preprocessor.IXDocPreprocessor;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.NullImageBehaviour;
import fr.opensagres.xdocreport.template.freemarker.FreemarkerTemplateEngine;
import freemarker.template.Configuration;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class ReportGenerator
implements IDocumentFieldsData {
    public static final String DOCX = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    public static final String PDF = "application/pdf";
    public static final String ODT = "application/vnd.oasis.opendocument.text";
    public static final String DASH = "-";
    protected InputStream template;
    protected String documentMimeType;
    protected String fontsPath;
    protected ContextMap contextMap;
    protected FieldsMetadata fieldsMetadata;
    protected List<ReportGeneratorPreProcessor> preProcessors;
    protected List<ReportGeneratorPostProcessor> postProcessors;
    public LinkedList<IReportConverter> converters;

    protected ReportGenerator(byte[] templateData, String fontsPath, String mimeType) {
        this.documentMimeType = mimeType;
        this.template = new BufferedInputStream(new ByteArrayInputStream(templateData));
        this.fontsPath = fontsPath;
        this.contextMap = new ContextMap();
        this.fieldsMetadata = new FieldsMetadata();
        this.preProcessors = new ArrayList<ReportGeneratorPreProcessor>();
        this.postProcessors = new ArrayList<ReportGeneratorPostProcessor>();
        this.loadDefaultConverts();
    }

    public void registerHelper(String helperKey, IDocumentHelper documentHelper) {
        this.contextMap.put(helperKey, (Object)documentHelper);
    }

    public void registerPreProcessors(ReportGeneratorPreProcessor preProcessor) {
        this.preProcessors.add(preProcessor);
    }

    public void registerPostProcessors(ReportGeneratorPostProcessor postProcessor) {
        this.postProcessors.add(postProcessor);
    }

    protected void configureTemplateEngine(ITemplateEngine engine) {
        FreemarkerTemplateEngine freemarkerEngine = (FreemarkerTemplateEngine)engine;
        Configuration freemarkerConfiguration = freemarkerEngine.getFreemarkerConfiguration();
        freemarkerConfiguration.setNumberFormat("0");
    }

    protected void loadDefaultConverts() {
        this.converters = new LinkedList();
        this.converters.add(new DocxToPdfReportConverter(this.fontsPath));
        this.converters.add(new DocxToDocxReportConverter());
        this.converters.add(DocumentTemplateEngine.getServiceImplementation().isOpenOfficeConverting() ? new OdtToPdfOpenofficeConverter() : new OdtToPdfReportConverter(this.fontsPath));
        this.converters.add(new OdtToOdtReportConverter());
        if (DocumentTemplateEngine.getServiceImplementation().isOpenOfficeConverting()) {
            this.converters.add(new OdtToDocxOpenofficeConverter());
        }
    }

    public ReportGenerator registerDataProvider(IReportDataProvider provider) {
        this.contextMap.registerProvider(provider);
        return this;
    }

    @Override
    public IDocumentFieldsData registerCollectionAsField(String collectionName) {
        this.fieldsMetadata.addFieldAsList(collectionName);
        return this;
    }

    @Override
    public IDocumentFieldsData registerImageNullBehaviour(String imageName, NullImageBehaviour behaviour) {
        this.fieldsMetadata.addFieldAsImage(imageName, behaviour);
        return this;
    }

    @Override
    public IDocumentFieldsData registerImage(String imageName, byte[] image) {
        ByteArrayImageProvider imageProvider = new ByteArrayImageProvider(image);
        this.contextMap.put(imageName, (Object)imageProvider);
        this.fieldsMetadata.addFieldAsImage(imageName, true);
        return this;
    }

    public ReportGenerator registerConverter(IReportConverter converter) {
        this.converters.addFirst(converter);
        return this;
    }

    public void generateReport(String outputFile) {
        this.generateReport(new File(outputFile));
    }

    public void generateReport(File outputFile) {
        byte[] report = this.generateReport();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(outputFile);
            fos.write(report);
        }
        catch (IOException e) {
            throw new ReportGenerationException("error writing the report", e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    throw new ReportGenerationException("error closing the report file", e);
                }
            }
        }
    }

    public byte[] generateReport() {
        return this.generateReportCached(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateReportCached(String reportId) {
        this.contextMap.registerFieldsMetadata();
        ByteArrayInputStream generatedReport = null;
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            String freemarkerEngineKind = TemplateEngineKind.Freemarker.name();
            IXDocReport report = null;
            report = Strings.isNullOrEmpty((String)reportId) ? XDocReport.loadReport((InputStream)this.template, (String)freemarkerEngineKind, (FieldsMetadata)this.fieldsMetadata, (XDocReportRegistry)XDocReportRegistry.getRegistry()) : XDocReport.getReport((String)reportId, (IXDocReportController)new XDocReportController(this.template, freemarkerEngineKind, this.fieldsMetadata, this.documentMimeType), (XDocReportRegistry)XDocReportRegistry.getRegistry());
            for (ReportGeneratorPreProcessor preProcessor : this.preProcessors) {
                report.addPreprocessor(preProcessor.getEntryName(), (IXDocPreprocessor)preProcessor);
            }
            this.configureTemplateEngine(report.getTemplateEngine());
            report.process((Map)this.contextMap, (OutputStream)outputStream);
            byte[] reportByteArray = outputStream.toByteArray();
            for (ReportGeneratorPostProcessor postProcessor : this.postProcessors) {
                reportByteArray = postProcessor.process(reportByteArray);
            }
            generatedReport = new ByteArrayInputStream(reportByteArray);
            Object object = this.convert(generatedReport);
            return object;
        }
        catch (Throwable e) {
            e.printStackTrace();
            if (e instanceof XDocReportException || e instanceof IOException) {
                throw new ReportGenerationException(e.getMessage(), e);
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (generatedReport != null) {
                try {
                    generatedReport.close();
                }
                catch (IOException e) {
                    throw new ReportGenerationException(e.getMessage(), e);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new ReportGenerationException(e.getMessage(), e);
                }
            }
        }
    }

    protected byte[] convert(InputStream generatedReport) {
        for (IReportConverter converter : this.converters) {
            if (!converter.convertFromType(ODT) || !converter.isForType(this.documentMimeType)) continue;
            return converter.convert(generatedReport);
        }
        throw new ReportGenerationException("Error converter not found for: " + this.documentMimeType);
    }

    public static ReportGenerator create(String template, String fontsPath, String mimeType) {
        try {
            return new ReportGenerator(FileUtils.readFileToByteArray((File)new File(template)), fontsPath, mimeType);
        }
        catch (FileNotFoundException e) {
            throw new ReportGenerationException("Error finding template", e);
        }
        catch (IOException e) {
            throw new ReportGenerationException("Error finding template", e);
        }
    }

    public static byte[] concatPDFs(Collection<byte[]> documents) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PdfCopyFields copy = new PdfCopyFields((OutputStream)outputStream);
            for (byte[] doc : documents) {
                copy.addDocument(new PdfReader(doc));
            }
            copy.close();
            return outputStream.toByteArray();
        }
        catch (DocumentException e) {
            throw new ReportGenerationException("Error in opening document", e);
        }
        catch (IOException e) {
            throw new ReportGenerationException("Error in opening document", e);
        }
    }

    private class ContextMap
    extends HashMap<String, Object> {
        private final LinkedList<IReportDataProvider> dataProviders = new LinkedList();
        private static final long serialVersionUID = 1L;

        private ContextMap() {
        }

        @Override
        public int size() {
            return super.size();
        }

        @Override
        public boolean isEmpty() {
            return this.dataProviders.isEmpty() && super.isEmpty();
        }

        @Override
        public boolean containsKey(final Object key) {
            return Iterables.any(this.dataProviders, (Predicate)new Predicate<IReportDataProvider>(){

                public boolean apply(IReportDataProvider provider) {
                    return provider.handleKey((String)key);
                }
            }) || super.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Object get(Object key) {
            for (IReportDataProvider provider : this.dataProviders) {
                if (!provider.handleKey((String)key)) continue;
                return provider.valueForKey((String)key);
            }
            return super.get(key);
        }

        @Override
        public Object put(String key, Object value) {
            return super.put(key, value);
        }

        @Override
        public Object remove(Object key) {
            return super.remove(key);
        }

        @Override
        public void putAll(Map m) {
            super.putAll(m);
        }

        @Override
        public void clear() {
            super.clear();
        }

        @Override
        public Set<String> keySet() {
            return super.keySet();
        }

        @Override
        public Collection<Object> values() {
            return super.values();
        }

        @Override
        public Set entrySet() {
            return this.entrySet();
        }

        public ContextMap registerProvider(IReportDataProvider provider) {
            this.dataProviders.addFirst(provider);
            return this;
        }

        public void registerFieldsMetadata() {
            for (IReportDataProvider provider : this.dataProviders) {
                provider.registerFieldsAndImages(ReportGenerator.this);
            }
        }

        public LinkedList<IReportDataProvider> getDataProviders() {
            return this.dataProviders;
        }
    }

    private static class XDocReportController
    extends AbstractXDocReportController {
        private InputStream sourceStream;
        private FieldsMetadata fieldsMetadata;

        public XDocReportController(InputStream sourceStream, String templateEngineKind, FieldsMetadata fieldsMetadata, String converterTypeFrom) {
            super(templateEngineKind, converterTypeFrom);
            this.sourceStream = sourceStream;
            this.fieldsMetadata = fieldsMetadata;
        }

        public InputStream getSourceStream() throws IOException {
            return this.sourceStream;
        }

        protected FieldsMetadata createFieldsMetadata() {
            return this.fieldsMetadata;
        }
    }
}

