/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.docs.util;

import com.google.common.collect.Lists;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.qubit.terra.docs.core.DocumentTemplateEngine;
import com.qubit.terra.docs.util.ReportGenerationException;
import java.awt.FontFormatException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FontManager {
    protected static final Map<Integer, String> STYLES_SUFFIX = new HashMap<Integer, String>();
    protected static FontManager fontManager;
    protected String fontsDirectory;
    protected List<FontEntry> fonts = Lists.newArrayList();

    public FontManager() {
        this.scanFonts();
    }

    protected void scanFonts() {
        this.fontsDirectory = DocumentTemplateEngine.getServiceImplementation().getFontsPath();
        try {
            File[] ttfFileArray;
            File file = new File(this.fontsDirectory);
            for (File ttfFile : ttfFileArray = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.getName().endsWith("ttf");
                }
            })) {
                FontEntry fontEntry = this.createFontEntry(ttfFile);
                this.fonts.add(fontEntry);
            }
        }
        catch (Exception e) {
            throw new ReportGenerationException("Error scanning fonts", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FontEntry createFontEntry(File ttfFile) throws FontFormatException, IOException, FileNotFoundException, DocumentException {
        try (FileInputStream is = null;){
            FontEntry fontEntry;
            is = new FileInputStream(ttfFile);
            byte[] fontData = RandomAccessFileOrArray.InputStreamToArray((InputStream)is);
            BaseFont baseFont = BaseFont.createFont((String)ttfFile.getName(), (String)"Identity-H", (boolean)true, (boolean)false, (byte[])fontData, null);
            FontEntry fontEntry2 = fontEntry = new FontEntry(ttfFile.getName(), baseFont);
            return fontEntry2;
        }
    }

    public BaseFont findBaseFont(String familyName, int style) {
        for (FontEntry f : this.fonts) {
            if (!f.isFor(familyName, style)) continue;
            return f.baseFont;
        }
        throw new ReportGenerationException(String.format("Font not found for name '%s' and style '%s' ", familyName, style));
    }

    public static FontManager sharedInstance() {
        if (fontManager == null) {
            fontManager = new FontManager();
        }
        if (!DocumentTemplateEngine.getServiceImplementation().getFontsPath().equals(FontManager.fontManager.fontsDirectory)) {
            fontManager.scanFonts();
        }
        return fontManager;
    }

    static {
        STYLES_SUFFIX.put(1, "b");
        STYLES_SUFFIX.put(2, "i");
        STYLES_SUFFIX.put(0, "");
        STYLES_SUFFIX.put(3, "bi");
    }

    protected static class FontEntry {
        protected String filename;
        protected BaseFont baseFont;

        public FontEntry(String filename, BaseFont baseFont) {
            this.filename = filename;
            this.baseFont = baseFont;
        }

        protected boolean isFor(String familyName, int style) {
            String suffix = STYLES_SUFFIX.get(style);
            return String.format("%s%s.ttf", familyName.toLowerCase().replace(' ', '_').replaceAll("[\\d]", ""), suffix).equals(this.filename);
        }
    }
}

