/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.qubAccessControl.domain;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.qubit.terra.framework.services.ServiceProvider;
import com.qubit.terra.framework.services.accessControl.AccessControlProfileManagerService;
import com.qubit.terra.framework.services.accessControl.Permission;
import com.qubit.terra.framework.services.accessControl.Profile;
import com.qubit.terra.framework.services.context.ApplicationUser;
import com.qubit.terra.framework.services.versioning.VersioningInformationReader;
import com.qubit.terra.framework.tools.primitives.LocalizedString;
import com.qubit.terra.qubAccessControl.domain.AccessControlPermission;
import com.qubit.terra.qubAccessControl.domain.AccessControlProfile$callable$cleanObjectsJSON;
import com.qubit.terra.qubAccessControl.domain.AccessControlProfile$callable$delete;
import com.qubit.terra.qubAccessControl.domain.AccessControlProfile$callable$isObjectValid;
import com.qubit.terra.qubAccessControl.domain.AccessControlProfile$callable$lookup;
import com.qubit.terra.qubAccessControl.domain.AccessControlProfile_Base;
import com.qubit.terra.qubAccessControl.domain.ObjectProfilesCache;
import com.qubit.terra.qubAccessControl.domain.ProviderStrategy;
import com.qubit.terra.qubAccessControl.services.ObjectProfileCacheService;
import com.qubit.terra.qubAccessControl.servlet.AccessControlBundle;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class AccessControlProfile
extends AccessControlProfile_Base
implements Profile {
    private static final Cache<AccessControlProfile, Set<? extends DomainObject>> CACHE;
    private static final Cache<String, Optional<AccessControlProfile>> PROFILE_CACHE;
    private transient SoftReference<Set<String>> parsedObjectIDs;
    public static final Advice advice$lookup;
    public static final Advice advice$isObjectValid;
    public static final Advice advice$cleanObjectsJSON;
    public static final Advice advice$delete;

    protected AccessControlProfile() {
        this.setDomainRoot(FenixFramework.getDomainRoot());
    }

    protected AccessControlProfile(String rawName, LocalizedString description, String code, String customExpression, String customExpressionValidator, Boolean restricted, Boolean system, String objectsClass, String objectsProviderStrategy) {
        this();
        this.setRawName(rawName);
        this.setDescription(description);
        this.setCode(code);
        this.setCustomExpression(customExpression);
        this.setCustomExpressionValidator(customExpressionValidator);
        this.setRestricted(restricted);
        this.setSystem(system);
        this.setObjectsClass(objectsClass);
        this.setObjectsProviderStrategy(objectsProviderStrategy);
        this.checkRules();
        PROFILE_CACHE.put((Object)code, Optional.of(this));
    }

    protected AccessControlProfile(String rawName, LocalizedString description, String customExpression, String customExpressionValidator, Boolean restricted, Boolean system, String objectsClass, String objectsProviderStrategy) {
        this();
        this.setRawName(rawName);
        this.setDescription(description);
        this.setCode(UUID.randomUUID().toString());
        this.setCustomExpression(customExpression);
        this.setCustomExpressionValidator(customExpressionValidator);
        this.setRestricted(restricted);
        this.setSystem(system);
        this.setObjectsClass(objectsClass);
        this.setObjectsProviderStrategy(objectsProviderStrategy);
        this.checkRules();
        PROFILE_CACHE.put((Object)this.getCode(), Optional.of(this));
    }

    public static AccessControlProfile create(String rawName, LocalizedString description, String code, String customExpression, String customExpressionValidator, Boolean restricted, Boolean system, String objectsClass, String objectsProviderStrategy) {
        if (code == null) {
            return new AccessControlProfile(rawName, description, customExpression, customExpressionValidator, restricted, system, objectsClass, objectsProviderStrategy);
        }
        if (AccessControlProfile.findByCode(code) != null) {
            throw new IllegalArgumentException(AccessControlBundle.get("error.AccessControlProfile.code.exists", code));
        }
        return new AccessControlProfile(rawName, description, code, customExpression, customExpressionValidator, restricted, system, objectsClass, objectsProviderStrategy);
    }

    public static AccessControlProfile create(String rawName, String code, String customExpression, String customExpressionValidator, Boolean restricted, Boolean system, String objectsClass, String objectsProviderStrategy) {
        return AccessControlProfile.create(rawName, new LocalizedString(), code, customExpression, customExpressionValidator, restricted, system, objectsClass, objectsProviderStrategy);
    }

    private void checkRules() {
        if (this.getDomainRoot() == null) {
            throw new IllegalStateException(AccessControlBundle.get("error.domainRoot.required"));
        }
        if (this.getRawName() == null) {
            throw new IllegalStateException(AccessControlBundle.get("error.AccessControlProfile.name.required"));
        }
        if (this.getCode() == null) {
            throw new IllegalStateException(AccessControlBundle.get("error.AccessControlProfile.code.required"));
        }
        if (this.getRestricted() == null) {
            throw new IllegalStateException(AccessControlBundle.get("error.AccessControlProfile.manager.required"));
        }
        if (this.getSystem() == null) {
            throw new IllegalStateException(AccessControlBundle.get("error.AccessControlProfile.manager.required"));
        }
        if (StringUtils.isNotBlank((String)this.getCustomExpression()) && StringUtils.isBlank((String)this.getCustomExpressionValidator())) {
            throw new IllegalStateException(AccessControlBundle.get("error.AccessControlProfile.customExpressionValidator.required"));
        }
    }

    public static AccessControlProfile findByName(String name) {
        return AccessControlProfile.findAll().stream().filter(p -> p.getRawName().equals(name)).findFirst().orElse(null);
    }

    public static AccessControlProfile findByCode(String code) {
        try {
            AccessControlProfile result = ((Optional)PROFILE_CACHE.get((Object)code, () -> AccessControlProfile.lookup(code))).orElse(null);
            if (result != null && FenixFramework.isDomainObjectValid((DomainObject)result)) {
                return result;
            }
            PROFILE_CACHE.invalidate((Object)code);
            return null;
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    private static Optional<AccessControlProfile> lookup(String string) {
        return (Optional)advice$lookup.perform((Callable)new AccessControlProfile$callable$lookup(string));
    }

    static /* synthetic */ Optional<AccessControlProfile> advised$lookup(String code) {
        return AccessControlProfile.findAll().stream().filter(op -> op.getCode().equals(code)).findFirst();
    }

    public static Set<AccessControlProfile> findAll() {
        return FenixFramework.getDomainRoot().getProfilesSet();
    }

    public boolean isRestricted() {
        return Boolean.TRUE.equals(this.getRestricted());
    }

    @Deprecated
    public boolean isLocked() {
        return this.isSystem();
    }

    public boolean isSystem() {
        return Boolean.TRUE.equals(this.getSystem());
    }

    @Deprecated
    public Boolean getLocked() {
        return Optional.ofNullable(this.getSystem()).orElseGet(() -> super.getLocked());
    }

    @Deprecated
    public void setLocked(Boolean locked) {
        if (locked == null) {
            super.setLocked(null);
            return;
        }
        this.setSystem(locked);
    }

    public boolean isAutoGenerated() {
        return Boolean.TRUE.equals(this.getAutoGenerated());
    }

    public Class getProviderClass() {
        String objectsClass = this.getObjectsClass();
        if (objectsClass != null) {
            try {
                return Class.forName(objectsClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("No class found for classname " + objectsClass, e);
            }
        }
        return null;
    }

    public void setObjects(String objects) {
        throw new UnsupportedOperationException("Default method is disabled please use addObject(object) or removeObject(object) to add or remove objects.");
    }

    private void setObjects(Set<? extends DomainObject> objects) {
        CACHE.put((Object)this, objects);
        if (!objects.isEmpty()) {
            JsonObject jsonObject = new JsonObject();
            Gson gson = new GsonBuilder().create();
            JsonElement objectsJsonArray = gson.toJsonTree(objects.stream().map(o -> o.getExternalId()).collect(Collectors.toList()));
            jsonObject.add(this.getProviderClass().getName(), objectsJsonArray);
            super.setObjects(jsonObject.toString());
        } else {
            super.setObjects("");
        }
        if (this.parsedObjectIDs != null) {
            this.parsedObjectIDs.clear();
        }
    }

    public <T extends DomainObject> void addAllObjects(Collection<T> objects) {
        Class providerClass = this.getProviderClass();
        if (providerClass == null) {
            throw new IllegalStateException("No object class defined");
        }
        Set nonMatchingClassObjects = objects.parallelStream().filter(o -> !providerClass.isAssignableFrom(o.getClass())).collect(Collectors.toSet());
        if (!nonMatchingClassObjects.isEmpty()) {
            throw new IllegalArgumentException("Expected to receive collection of objects of type " + providerClass.getName());
        }
        Set<T> finalObjects = this.provideObjects();
        finalObjects.addAll(objects);
        this.setObjects(finalObjects);
        objects.forEach(object -> ObjectProfilesCache.addToCache(object, this));
    }

    public void addObject(Object object) {
        if (!(object instanceof DomainObject)) {
            throw new IllegalArgumentException("Can only add domain objects");
        }
        this.addObject((DomainObject)object);
    }

    public <T extends DomainObject> void addObject(T object) {
        Class providerClass = this.getProviderClass();
        if (providerClass == null) {
            throw new IllegalStateException("No object class defined");
        }
        if (!providerClass.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("Expected to receive object of type " + providerClass.getName() + " but received object of type " + object.getClass().getName());
        }
        Set<T> objects = this.provideObjects();
        objects.add(object);
        this.setObjects(objects);
        ObjectProfilesCache.addToCache(object, this);
    }

    public <T extends DomainObject> void removeAllObjects(Set<T> objects) {
        Class providerClass = this.getProviderClass();
        if (providerClass == null) {
            throw new IllegalStateException("No object class defined");
        }
        Set nonMatchingClassObjects = objects.parallelStream().filter(o -> !providerClass.isAssignableFrom(o.getClass())).collect(Collectors.toSet());
        if (!nonMatchingClassObjects.isEmpty()) {
            throw new IllegalArgumentException("Expected to receive collection of objects of type " + providerClass.getName());
        }
        Set<T> finalObjects = this.provideObjects();
        finalObjects.removeAll(objects);
        this.setObjects(finalObjects);
        objects.forEach(object -> ObjectProfilesCache.removeFromCache(object, this));
    }

    public void removeObject(Object object) {
        if (!(object instanceof DomainObject)) {
            throw new IllegalArgumentException("Can only remove domain objects");
        }
        this.removeObject((DomainObject)object);
    }

    public void removeObject(DomainObject object) {
        Class providerClass = this.getProviderClass();
        if (providerClass == null) {
            throw new IllegalStateException("No object class defined");
        }
        if (!providerClass.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("Expected to receive object of type " + providerClass.getName() + " but received object of type " + object.getClass().getName());
        }
        Set objects = this.provideObjects();
        objects.remove(object);
        this.setObjects(objects);
        ObjectProfilesCache.removeFromCache(object, this);
    }

    public String getObjects() {
        throw new UnsupportedOperationException("Default method is disabled please use provideObjects().");
    }

    protected ProviderStrategy getProvider() {
        return ProviderStrategy.getProvider(this.getObjectsProviderStrategy());
    }

    public <T extends DomainObject> Boolean containsObject(T object) {
        if ("com.qubit.terra.qubAccessControl.domain.ProvideAssociatedStrategy".equals(this.getObjectsProviderStrategy())) {
            return this.parseObjectsJSONToStringArray().contains(object.getExternalId());
        }
        ProviderStrategy provider = this.getProvider();
        return provider != null ? provider.contains(this, object) : false;
    }

    private Set<String> parseObjectsJSONToStringArray() {
        if (this.parsedObjectIDs != null && this.parsedObjectIDs.get() != null) {
            return this.parsedObjectIDs.get();
        }
        HashSet<String> result = new HashSet<String>();
        if (!StringUtils.isBlank((String)super.getObjects())) {
            JsonObject json = (JsonObject)new Gson().fromJson(super.getObjects(), JsonObject.class);
            JsonArray objectsOIDArray = json.getAsJsonArray(this.getObjectsClass());
            objectsOIDArray.forEach(oid -> result.add(oid.getAsString()));
        }
        this.parsedObjectIDs = new SoftReference(result);
        return result;
    }

    public <T> Set<T> provideObjects() {
        ProviderStrategy provider = this.getProvider();
        if (provider == null) {
            return new HashSet();
        }
        return provider.provideAll(this);
    }

    protected <T extends DomainObject> Set<T> internalProvideObjects() {
        HashSet cacheResult = new HashSet();
        HashSet result = new HashSet();
        HashSet<String> oidsToRemove = new HashSet<String>();
        try {
            cacheResult.addAll((Collection)CACHE.get((Object)this, () -> this.parseObjectsJSON()));
        }
        catch (ExecutionException e) {
            return Collections.EMPTY_SET;
        }
        cacheResult.stream().forEach(object -> {
            if (this.isObjectValid(object)) {
                result.add(object);
            } else {
                oidsToRemove.add(object.getExternalId());
            }
        });
        if (!oidsToRemove.isEmpty()) {
            this.cleanObjectsJSON(oidsToRemove);
        }
        return result;
    }

    private <T extends DomainObject> boolean isObjectValid(T t) {
        return (Boolean)advice$isObjectValid.perform((Callable)new AccessControlProfile$callable$isObjectValid(this, t));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ boolean advised$isObjectValid(AccessControlProfile this_, DomainObject object) {
        return FenixFramework.isDomainObjectValid((DomainObject)object);
    }

    private <T extends DomainObject> Set<T> parseObjectsJSON() {
        HashSet result = new HashSet();
        HashSet oids = new HashSet();
        if (!StringUtils.isBlank((String)super.getObjects())) {
            JsonObject json = (JsonObject)new Gson().fromJson(super.getObjects(), JsonObject.class);
            JsonArray objectsOIDArray = json.getAsJsonArray(this.getObjectsClass());
            objectsOIDArray.forEach(oid -> {
                String oidAsString = oid.getAsString();
                result.add(FenixFramework.getDomainObject((String)oidAsString));
                oids.add(oidAsString);
            });
        }
        if (this.parsedObjectIDs != null) {
            this.parsedObjectIDs.clear();
        }
        this.parsedObjectIDs = new SoftReference(oids);
        return result;
    }

    private void cleanObjectsJSON(Set<String> set) {
        Object object = advice$cleanObjectsJSON.perform((Callable)new AccessControlProfile$callable$cleanObjectsJSON(this, set));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$cleanObjectsJSON(AccessControlProfile this_, Set oidsToRemove) {
        CACHE.invalidate((Object)this_);
        if (this_.parsedObjectIDs != null) {
            this_.parsedObjectIDs.clear();
        }
        String objects = super.getObjects();
        for (String oid : oidsToRemove) {
            objects = objects.replace("\"" + oid + "\"", "").replace(",,", ",").replace("[,", "[").replace(",]", "]");
        }
        super.setObjects(objects);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new AccessControlProfile$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(AccessControlProfile this_) {
        if (this_.isSystem()) {
            throw new IllegalStateException(AccessControlBundle.get("error.AccessControlProfile.delete.protected"));
        }
        if (!this_.getParentSet().isEmpty()) {
            throw new IllegalStateException(AccessControlBundle.get("error.AccessControlProfile.delete") + this_.getParentSet().stream().map(profile -> profile.getRawName()).collect(Collectors.joining(",")));
        }
        this_.getMembers().forEach(u -> this.removeMember((ApplicationUser)u));
        this_.removeFromObjectsCache();
        this_.getChildSet().forEach(child -> this.removeChild((AccessControlProfile)((Object)child)));
        this_.getPermissionSet().forEach(permission -> this.removePermission((AccessControlPermission)((Object)permission)));
        this_.setDomainRoot(null);
        PROFILE_CACHE.invalidate((Object)this_.getCode());
        super.deleteDomainObject();
    }

    public void addParent(AccessControlProfile parent) {
        if (this.validate(parent)) {
            super.addParent(parent);
        }
    }

    public void addChild(AccessControlProfile child) {
        if (this.validate(child)) {
            super.addChild(child);
        }
    }

    private boolean validate(AccessControlProfile child) {
        if (child == this) {
            throw new IllegalArgumentException(AccessControlBundle.get("error.AccessControlProfile.addProfileToItself", this.getRawName()));
        }
        if (this.findAllParents().contains((Object)child)) {
            throw new IllegalArgumentException(AccessControlBundle.get("error.AccessControlProfile.treeCycle", this.getRawName(), child.getRawName()));
        }
        return true;
    }

    public Set<AccessControlProfile> findAllParents() {
        HashSet<AccessControlProfile> parents = new HashSet<AccessControlProfile>();
        parents.addAll(this.addParents(this));
        return parents;
    }

    private Set<AccessControlProfile> addParents(AccessControlProfile profile) {
        HashSet<AccessControlProfile> parents = new HashSet<AccessControlProfile>();
        parents.addAll(profile.getParentSet());
        profile.getParentSet().forEach(p -> parents.addAll(this.addParents((AccessControlProfile)((Object)p))));
        return parents;
    }

    public void setObjectsClass(String objectsClass) {
        this.removeFromObjectsCache();
        super.setObjectsClass(objectsClass);
        this.addToObjectsCache();
    }

    public void setObjectsProviderStrategy(String objectsProviderStrategy) {
        this.removeFromObjectsCache();
        super.setObjectsProviderStrategy(objectsProviderStrategy);
        this.addToObjectsCache();
    }

    public void removeFromObjectsCache() {
        if (this.getProviderClass() == null || this.getObjectsProviderStrategy() == null) {
            return;
        }
        if ("com.qubit.terra.qubAccessControl.domain.ProvideAssociatedStrategy".equals(this.getObjectsProviderStrategy())) {
            Set<DomainObject> objects = this.provideObjects();
            objects.forEach(object -> ObjectProfilesCache.removeFromCache(object, this));
        } else {
            ObjectProfilesCache.removeFromAllTypeOrSubtypeCache(this.getProviderClass(), this);
            ObjectProfileCacheService.getAllSubClasses(this.getProviderClass()).forEach(clazz -> ObjectProfilesCache.removeFromAllTypeOrSubtypeCache(clazz, this));
        }
    }

    public void addToObjectsCache() {
        if (this.getProviderClass() == null || this.getObjectsProviderStrategy() == null) {
            return;
        }
        if ("com.qubit.terra.qubAccessControl.domain.ProvideAssociatedStrategy".equals(this.getObjectsProviderStrategy())) {
            Set<DomainObject> objects = this.provideObjects();
            objects.forEach(object -> ObjectProfilesCache.addToCache(object, this));
        } else {
            ObjectProfilesCache.addToAllTypeOrSubtypeCache(this.getProviderClass(), this);
            ObjectProfileCacheService.getAllSubClasses(this.getProviderClass()).forEach(clazz -> ObjectProfilesCache.addToAllTypeOrSubtypeCache(clazz, this));
        }
    }

    public void setName(LocalizedString name) {
        this.setRawName(name.toString());
    }

    public LocalizedString getName() {
        return new LocalizedString(this.getRawName());
    }

    public Set<Profile> getParents() {
        return this.getParentSet().stream().collect(Collectors.toSet());
    }

    public Set<Profile> getChilds() {
        return this.getChildSet().stream().collect(Collectors.toSet());
    }

    public Set<Permission> getPermissions() {
        return this.getPermissionSet().stream().collect(Collectors.toSet());
    }

    public DateTime getCreationDate() {
        return ((VersioningInformationReader)ServiceProvider.getService(VersioningInformationReader.class)).getCreationDate((Object)this);
    }

    public Collection<ApplicationUser> getMembers() {
        return ((AccessControlProfileManagerService)ServiceProvider.getService(AccessControlProfileManagerService.class)).getMembers((Profile)this);
    }

    public void removePermission(Permission permission) {
        this.removePermission((AccessControlPermission)permission);
    }

    public void addChildProfile(Profile profile) {
        this.addChild((AccessControlProfile)profile);
    }

    public void removeChildProfile(Profile profile) {
        this.removeChild((AccessControlProfile)profile);
    }

    public void addPermission(Permission permission) {
        this.addPermission((AccessControlPermission)permission);
    }

    static {
        advice$lookup = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$isObjectValid = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        advice$cleanObjectsJSON = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).maximumSize(10000L).expireAfterWrite(24L, TimeUnit.HOURS).build();
        PROFILE_CACHE = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).maximumSize(10000L).expireAfterWrite(2L, TimeUnit.HOURS).build();
    }
}

