/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.terra.ldapclient;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryReplyElement {
    private static String EMPTY = "";
    private final HashMap<String, List<String>> responseMap = new HashMap();
    private final String[] replyAttributes;

    QueryReplyElement(String[] replyAttributes) {
        this.replyAttributes = replyAttributes;
    }

    void addAttribute(String id, String value) {
        List<String> list = this.responseMap.get(id);
        if (list == null) {
            list = new ArrayList<String>();
            this.responseMap.put(id, list);
        }
        list.add(value);
    }

    public boolean isWithAllAttributesFilled() {
        Set<String> keySet = this.responseMap.keySet();
        if (keySet.size() == this.replyAttributes.length) {
            new HashSet<String>(keySet).removeAll(Arrays.asList(this.replyAttributes));
            return keySet.size() == 0;
        }
        return false;
    }

    public boolean isAttributePresent(String id) {
        return this.responseMap.get(id) != null;
    }

    public List<String> getListAttribute(String id) {
        List<String> list = this.responseMap.get(id);
        return list == null ? Collections.EMPTY_LIST : list;
    }

    public String getSimpleAttribute(String id) {
        List<String> list = this.responseMap.get(id);
        if (list == null) {
            return EMPTY;
        }
        if (list.size() > 1) {
            throw new RuntimeException("Attribute with id: " + id + " is not a simple attribute since there are " + list.size() + " values for it. Use getListAttribute instead!");
        }
        return list.isEmpty() ? EMPTY : list.get(0);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Requested attributes: ");
        builder.append(this.replyAttributes);
        builder.append("\n");
        builder.append("WithAllAttributesFilled: ");
        builder.append(this.isWithAllAttributesFilled());
        builder.append("\n");
        builder.append("Present attributes: ");
        Set<Map.Entry<String, List<String>>> entrySet = this.responseMap.entrySet();
        for (Map.Entry<String, List<String>> entry : entrySet) {
            builder.append(entry.getKey());
            builder.append(": ");
            builder.append(entry.getValue());
            builder.append("\n");
        }
        return builder.toString();
    }
}

