/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.santandersdk.service;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.santandersdk.dto.CardPreviewBean;
import org.fenixedu.santandersdk.dto.CreateRegisterRequest;
import org.fenixedu.santandersdk.dto.PickupAddress;
import org.fenixedu.santandersdk.exception.SantanderMissingInformationException;
import org.fenixedu.santandersdk.exception.SantanderValidationException;
import org.fenixedu.santandersdk.service.SantanderEntryValidator;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SantanderLineGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SantanderLineGenerator.class);
    private final Map<String, String> charReplacementMap = new HashMap<String, String>();
    private final CharsetEncoder latin1CharsetEncoder = StandardCharsets.ISO_8859_1.newEncoder();
    private SantanderEntryValidator santanderEntryValidator;

    public SantanderLineGenerator(SantanderEntryValidator santanderEntryValidator) {
        this.santanderEntryValidator = santanderEntryValidator;
        this.fillCharReplacementMap();
    }

    private String normalizeCardName(String name) {
        if (!this.latin1CharsetEncoder.canEncode(name) || this.nameContainsCharReplacements(name)) {
            for (String replacementChar : this.charReplacementMap.keySet()) {
                name = name.replaceAll(replacementChar, this.charReplacementMap.get(replacementChar));
            }
            return StringNormalizer.normalizePreservingCapitalizedLetters((String)name);
        }
        return name.trim();
    }

    private boolean nameContainsCharReplacements(String name) {
        return this.charReplacementMap.keySet().stream().anyMatch(name::contains);
    }

    public CardPreviewBean generateLine(CreateRegisterRequest request) throws SantanderValidationException {
        ArrayList<String> errors = new ArrayList<String>();
        String role = request.getRole();
        if (Strings.isNullOrEmpty((String)request.getUsername())) {
            errors.add("santander.sdk.error.line.generation.missing.username");
        }
        if (Strings.isNullOrEmpty((String)request.getCardName())) {
            errors.add("santander.sdk.error.line.generation.missing.name");
        }
        if (Strings.isNullOrEmpty((String)request.getFullName())) {
            errors.add("santander.sdk.error.line.generation.missing.name");
        }
        if (Strings.isNullOrEmpty((String)request.getCampus())) {
            errors.add("santander.sdk.error.line.generation.missing.campus");
        }
        if (role.equals("TEACHER") && Strings.isNullOrEmpty((String)request.getDepartmentAcronym())) {
            errors.add("santander.sdk.error.line.generation.missing.department.acronym");
        }
        if (request.getPhoto() == null) {
            errors.add("santander.sdk.error.line.generation.missing.photo");
        }
        if (!errors.isEmpty()) {
            String errorsMessage = String.join((CharSequence)"\n", errors);
            throw new SantanderMissingInformationException(errorsMessage);
        }
        CardPreviewBean cardPreviewBean = new CardPreviewBean();
        ArrayList<String> values = new ArrayList<String>();
        String recordType = "2";
        String idNumber = request.getUsername();
        String[] names = this.harvestNames(request.getFullName());
        String cardName = this.normalizeCardName(request.getCardName()).toUpperCase();
        String encodedCardName = new String(cardName.getBytes(Charset.forName("Windows-1252")), Charset.forName("Windows-1252"));
        String name = names[0];
        String surname = names[1];
        String middleNames = names[2];
        String degreeCode = "";
        PickupAddress pickupAddress = request.getPickupAddress();
        if (pickupAddress == null) {
            throw new SantanderMissingInformationException("santander.sdk.error.line.generation.user.has.no.current.campus");
        }
        String address1 = pickupAddress.getAddress1();
        String address2 = pickupAddress.getAddress2();
        String zipCode = pickupAddress.getZipCode();
        String town = pickupAddress.getZipDescriptive();
        String homeCountry = "";
        String residenceCountry = request.getUsername();
        DateTime now = DateTime.now();
        DateTime expireDate_dateTime = now.plusYears(3).dayOfMonth().withMaximumValue().withHourOfDay(23).withMinuteOfHour(59).withSecondOfMinute(59);
        String expireDate = now.toString("yyyy") + "/" + expireDate_dateTime.toString("yyyy");
        String backNumber = this.makeZeroPaddedNumber(Integer.parseInt(request.getUsername()), 10);
        if (backNumber == null) {
            throw new SantanderValidationException("santander.sdk.error.line.generation.user.invalid.username.size");
        }
        String curricularYear = "";
        String executionYear_field = "";
        String unit = "";
        if (role.equals("TEACHER") && !Strings.isNullOrEmpty((String)request.getDepartmentAcronym())) {
            unit = request.getDepartmentAcronym();
        }
        String accessControl = "";
        String expireData_AAMM = expireDate_dateTime.toString("yy") + expireDate_dateTime.toString("MM");
        String templateCode = "";
        String actionCode = request.getAction().name();
        String roleCode = this.getRoleCode(role);
        String roleDesc = this.getRoleDescription(role);
        String idDocumentType = "0";
        String checkDigit = "";
        String cardType = "00";
        String expeditionCode = "00";
        String detourAddress1 = "";
        String detourAddress2 = "";
        String detourAddress3 = "";
        String detourZipCode = "";
        String detourTown = "";
        String additionalData = "1";
        String email = "";
        String phone = "";
        String photoFlag = "1";
        String photoRef = "";
        String signatureFlag = "0";
        String signatureRef = "";
        String digCertificateFlag = "0";
        String digCertificateRef = "";
        String filler = "";
        String endFlag = "1";
        values.add("2");
        values.add(idNumber);
        values.add(name);
        values.add(surname);
        values.add(middleNames);
        values.add(address1);
        values.add(address2);
        values.add(zipCode);
        values.add(town);
        values.add("");
        values.add(residenceCountry);
        values.add(expireDate);
        values.add("");
        values.add(backNumber);
        values.add("");
        values.add("");
        values.add(unit);
        values.add("");
        values.add(expireData_AAMM);
        values.add("");
        values.add(actionCode);
        values.add(roleCode);
        values.add(roleDesc);
        values.add("0");
        values.add("");
        values.add("00");
        values.add("00");
        values.add("");
        values.add("");
        values.add("");
        values.add("");
        values.add("");
        values.add("1");
        values.add(encodedCardName);
        values.add("");
        values.add("");
        values.add("1");
        values.add("");
        values.add("0");
        values.add("");
        values.add("0");
        values.add("");
        values.add("");
        values.add("1");
        try {
            cardPreviewBean.setRequestLine(this.santanderEntryValidator.generateLine(values));
        }
        catch (SantanderValidationException sve) {
            LOGGER.error(String.format("Error generation line for user %s", request.getUsername()), (Throwable)sve);
            throw new SantanderValidationException("santander.sdk.error.line.generation.failed");
        }
        cardPreviewBean.setExpiryDate(expireDate_dateTime);
        cardPreviewBean.setCardName(encodedCardName);
        cardPreviewBean.setIdentificationNumber(idNumber);
        cardPreviewBean.setPhoto(request.getPhoto());
        cardPreviewBean.setRole(roleDesc);
        return cardPreviewBean;
    }

    private String getRoleCode(String role) {
        switch (role) {
            case "STUDENT": {
                return "01";
            }
            case "TEACHER": {
                return "02";
            }
            case "EMPLOYEE": {
                return "03";
            }
        }
        return "99";
    }

    private String[] harvestNames(String name) {
        String[] result = new String[3];
        String purgedName = this.cleanNames(name);
        String[] names = purgedName.split(" ");
        result[0] = names[0].length() > 15 ? names[0].substring(0, 15) : names[0];
        result[1] = names[names.length - 1].length() > 15 ? names[names.length - 1].substring(0, 15) : names[names.length - 1];
        StringBuilder midNames = new StringBuilder(names.length > 2 ? names[1] : "");
        for (int i = 2; i < names.length - 1 && midNames.length() + names[i].length() + 1 <= 40; ++i) {
            midNames.append(" ");
            midNames.append(names[i]);
        }
        result[2] = midNames.toString();
        return result;
    }

    private String cleanNames(String name) {
        return this.purgeString(name).trim();
    }

    private String purgeString(String name) {
        if (!CharMatcher.forPredicate(Character::isLetter).or(CharMatcher.forPredicate(Character::isWhitespace)).matchesAllOf((CharSequence)name)) {
            char[] ca = new char[name.length()];
            int j = 0;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (!Character.isLetter(c) && c != ' ') continue;
                ca[j++] = c;
            }
            return new String(ca);
        }
        return name;
    }

    private String getRoleDescription(String role) {
        switch (role) {
            case "STUDENT": {
                return "Estudante/Student";
            }
            case "TEACHER": {
                return "Docente/Faculty";
            }
            case "EMPLOYEE": {
                return "Funcionario/Staff";
            }
            case "RESEARCHER": {
                return "Invest./Researcher";
            }
            case "GRANT_OWNER": {
                return "Bolseiro/Grant Owner";
            }
        }
        return "00";
    }

    private String makeZeroPaddedNumber(int number, int size) {
        if (String.valueOf(number).length() > size) {
            return null;
        }
        String format = "%0" + size + "d";
        return String.format(format, number);
    }

    private void fillCharReplacementMap() {
        this.charReplacementMap.put("--", " ");
        this.charReplacementMap.put("-", " ");
        this.charReplacementMap.put("'", "");
        this.charReplacementMap.put("\u0142", "l");
        this.charReplacementMap.put("\u0141", "L");
        this.charReplacementMap.put("\u0110", "D");
        this.charReplacementMap.put("\u0111", "d");
        this.charReplacementMap.put("\u00e6", "ae");
        this.charReplacementMap.put("\u0131", "i");
        this.charReplacementMap.put("I", "I");
        this.charReplacementMap.put("\u00d1", "N");
        this.charReplacementMap.put("\u00f1", "n");
        this.charReplacementMap.put("\u00ef", "i");
        this.charReplacementMap.put("\u00cf", "I");
        this.charReplacementMap.put("\u00f8", "o");
        this.charReplacementMap.put("\u00d8", "O");
        this.charReplacementMap.put("\u00f6", "o");
        this.charReplacementMap.put("\u00d6", "O");
        this.charReplacementMap.put("\u0161", "s");
        this.charReplacementMap.put("\u0160", "S");
        this.charReplacementMap.put("\u0165", "t");
        this.charReplacementMap.put("\u0164", "T");
        this.charReplacementMap.put("\u0107", "c");
        this.charReplacementMap.put("\u0106", "C");
        this.charReplacementMap.put("\u0151", "o");
        this.charReplacementMap.put("\u0150", "O");
        this.charReplacementMap.put("\u010d", "c");
        this.charReplacementMap.put("\u010c", "C");
        this.charReplacementMap.put("\u0144", "n");
        this.charReplacementMap.put("\u0143", "N");
        this.charReplacementMap.put("\u017c", "z");
        this.charReplacementMap.put("\u017b", "Z");
        this.charReplacementMap.put("\u017e", "z");
        this.charReplacementMap.put("\u017d", "Z");
        this.charReplacementMap.put("\u016f", "u");
        this.charReplacementMap.put("\u016e", "U");
        this.charReplacementMap.put("\u00e5", "a");
        this.charReplacementMap.put("\u00c5", "A");
        this.charReplacementMap.put("\u015b", "s");
        this.charReplacementMap.put("\u015a", "S");
        this.charReplacementMap.put("\u013e", "l");
        this.charReplacementMap.put("\u013d", "L");
        this.charReplacementMap.put("\u0119", "e");
        this.charReplacementMap.put("\u0118", "E");
        this.charReplacementMap.put("\u011f", "g");
        this.charReplacementMap.put("\u011e", "G");
        this.charReplacementMap.put("\u00fc", "u");
        this.charReplacementMap.put("\u00dc", "U");
        this.charReplacementMap.put("\u015f", "s");
        this.charReplacementMap.put("\u015e", "S");
        this.charReplacementMap.put("\u00e4", "a");
        this.charReplacementMap.put("\u00c4", "A");
        this.charReplacementMap.put("\u00eb", "e");
        this.charReplacementMap.put("\u00cb", "E");
    }
}

