/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.qubdocs.academic.documentRequests.providers;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.qubit.terra.docs.util.IDocumentFieldsData;
import com.qubit.terra.docs.util.IReportDataProvider;
import java.util.Comparator;
import java.util.Set;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.IEnrolment;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.studentCurriculum.ExternalEnrolment;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.qubdocs.academic.documentRequests.providers.CurriculumEntry;

public class CurriculumEntryRemarksDataProvider
implements IReportDataProvider {
    public static final Comparator<RemarkEntry> ENTRY_COMPARATOR = new Comparator<RemarkEntry>(){

        @Override
        public int compare(RemarkEntry o1, RemarkEntry o2) {
            return o1.remarkNumber.compareTo(o2.remarkNumber);
        }
    };
    protected static final String KEY = "curriculumEntryRemarks";
    protected char counter = (char)97;
    private Set<RemarkEntry> remarkEntries = Sets.newTreeSet(ENTRY_COMPARATOR);
    protected String key = "curriculumEntryRemarks";
    protected Registration registration;

    public CurriculumEntryRemarksDataProvider(Registration registration) {
        this.registration = registration;
    }

    public void registerFieldsAndImages(IDocumentFieldsData documentFieldsData) {
    }

    public boolean handleKey(String key) {
        return this.key.equals(key);
    }

    public Object valueForKey(String key) {
        if (!this.handleKey(key)) {
            return null;
        }
        return this.remarkEntries;
    }

    protected RemarkEntry addCurriculumEntryToRemarkEntry(CurriculumEntry input) {
        RemarkEntry result = null;
        LocalizedString description = input.getCurriculumEntryDescription();
        if (description != null) {
            RemarkEntryType remarkEntryType;
            for (RemarkEntry iter : Sets.newHashSet(this.remarkEntries)) {
                if (!iter.addIf(input)) continue;
                result = iter;
                break;
            }
            if (result == null && (remarkEntryType = this.getRemarkEntryType(input)) != null) {
                char c = this.counter;
                this.counter = (char)(c + '\u0001');
                result = new RemarkEntry(String.valueOf(c), remarkEntryType, input);
                this.remarkEntries.add(result);
            }
        }
        return result;
    }

    public Set<RemarkEntry> getRemarkEntriesFor(final CurriculumEntry curriculumEntry) {
        return Sets.filter(this.remarkEntries, (Predicate)new Predicate<RemarkEntry>(){

            public boolean apply(RemarkEntry remarkEntry) {
                return remarkEntry.curriculumEntries.contains(curriculumEntry);
            }
        });
    }

    public RemarkEntryType getRemarkEntryType(CurriculumEntry entry) {
        ExternalEnrolment externalEnrolment;
        if (entry.isExternal() && (externalEnrolment = (ExternalEnrolment)entry.getICurriculumEntry()).getAcademicUnit() != null) {
            return RemarkEntryType.INSTITUTION;
        }
        if (entry.isExternal() || this.isDismissal(entry)) {
            return RemarkEntryType.CREDITS;
        }
        return null;
    }

    public boolean isDismissal(CurriculumEntry entry) {
        if (entry.isDismissal()) {
            return true;
        }
        if (entry.isIEnrolment() && ((IEnrolment)entry.getICurriculumEntry()).isEnrolment()) {
            return this.hasAnyDismissal(this.registration.getLastStudentCurricularPlan(), (Enrolment)entry.getICurriculumEntry());
        }
        return false;
    }

    private boolean hasAnyDismissal(StudentCurricularPlan studentCurricularPlan, Enrolment enrolment) {
        return studentCurricularPlan.getCreditsSet().stream().anyMatch(c -> c.getEnrolmentsSet().stream().anyMatch(ew -> ew.getIEnrolment() == enrolment));
    }

    public class RemarkEntry {
        protected String remarkNumber;
        private Set<CurriculumEntry> curriculumEntries = Sets.newHashSet();
        private RemarkEntryType type;
        private LocalizedString curriculumEntryDescription;

        public RemarkEntry(String remarkNumber, RemarkEntryType remarkEntryType, CurriculumEntry curriculumEntry) {
            this.remarkNumber = remarkNumber;
            this.type = remarkEntryType;
            this.curriculumEntries.add(curriculumEntry);
        }

        public boolean addIf(CurriculumEntry entry) {
            return entry.getCurriculumEntryDescription().equals((Object)this.getCurriculumEntryDescription()) && this.curriculumEntries.add(entry);
        }

        protected boolean isInstitutionEntry() {
            return RemarkEntryType.INSTITUTION == this.type;
        }

        protected boolean isCreditsEntry() {
            return RemarkEntryType.CREDITS == this.type;
        }

        public LocalizedString getDescription() {
            LocalizedString result = this.getCurriculumEntryDescription();
            LocalizedString.Builder builder = new LocalizedString.Builder();
            result.forEach((locale, value) -> builder.with(locale, this.remarkNumber + ") " + value));
            result = builder.build();
            return result;
        }

        private LocalizedString getCurriculumEntryDescription() {
            if (this.curriculumEntryDescription == null) {
                this.curriculumEntryDescription = new LocalizedString();
                if (!this.curriculumEntries.isEmpty()) {
                    this.curriculumEntryDescription = this.curriculumEntries.iterator().next().getCurriculumEntryDescription();
                }
            }
            return this.curriculumEntryDescription;
        }
    }

    public static enum RemarkEntryType {
        INSTITUTION,
        CREDITS;


        public String getQualifiedName() {
            return ((Object)((Object)this)).getClass().getSimpleName() + "." + this.name();
        }
    }
}

