/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentSigner$callable$create;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentSigner$callable$edit;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentSigner_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DocumentSigner
extends DocumentSigner_Base {
    public static final Comparator<DocumentSigner> DEFAULT_COMPARATOR;
    public static final Advice advice$edit;
    public static final Advice advice$create;

    protected DocumentSigner() {
        this.setBennu(Bennu.getInstance());
    }

    protected DocumentSigner(AdministrativeOffice administrativeOffice, String responsibleName, String responsibleShortName, LocalizedString responsibleFunction, LocalizedString responsibleUnit, Gender responsibleGender) {
        this();
        this.setAdministrativeOffice(administrativeOffice);
        this.setResponsibleName(responsibleName);
        this.setResponsibleShortName(responsibleShortName);
        this.setResponsibleFunction(responsibleFunction);
        this.setResponsibleUnit(responsibleUnit);
        this.setResponsibleGender(responsibleGender);
        if (DocumentSigner.findDefaultDocumentSignature() == null) {
            this.setDefaultSignature(true);
        }
    }

    private void checkRules() {
    }

    public void edit(String string, String string2, LocalizedString localizedString, LocalizedString localizedString2, Gender gender, boolean bl) {
        Object object = advice$edit.perform((Callable)new DocumentSigner$callable$edit(this, string, string2, localizedString, localizedString2, gender, bl));
    }

    static /* synthetic */ void advised$edit(DocumentSigner this_, String responsibleName, String responsibleShortName, LocalizedString responsibleFunction, LocalizedString responsibleUnit, Gender responsibleGender, boolean responsibleDefault) {
        this_.setResponsibleName(responsibleName);
        this_.setResponsibleShortName(responsibleShortName);
        this_.setResponsibleFunction(responsibleFunction);
        this_.setResponsibleUnit(responsibleUnit);
        this_.setResponsibleGender(responsibleGender);
        this_.setDefaultSignature(responsibleDefault);
    }

    public boolean isDeletable() {
        return this.getAcademicServiceRequestsSet().stream().filter(AcademicServiceRequest::finishedSuccessfully).count() == 0L;
    }

    public void delete() {
        if (!this.isDeletable()) {
            throw new DomainException("serviceRequests.documentRequests.DocumentSigner.cant.delete.signer.associated.with.concluded.or.delivered.documents", new String[0]);
        }
        DocumentSigner defaultSigner = DocumentSigner.findDefaultDocumentSignature();
        for (AcademicServiceRequest asr : this.getAcademicServiceRequestsSet()) {
            asr.setDocumentSigner(defaultSigner != this ? defaultSigner : null);
        }
        this.setBennu(null);
        this.setAdministrativeOffice(null);
        this.deleteDomainObject();
    }

    public boolean isDefaultSignature() {
        return this.getDefaultSignature() != null ? this.getDefaultSignature() : false;
    }

    public void setDefaultSignature(Boolean defaultSignature) {
        DocumentSigner defaultDocumentSignature;
        if (defaultSignature.booleanValue() && (defaultDocumentSignature = DocumentSigner.findDefaultDocumentSignature()) != null) {
            defaultDocumentSignature.setDefaultSignature(false);
        }
        super.setDefaultSignature(defaultSignature);
    }

    public String getResponsibleShortName() {
        String shortName = super.getResponsibleShortName();
        return shortName == null || shortName.trim().isEmpty() ? this.getResponsibleName() : shortName;
    }

    public static Stream<DocumentSigner> findAll() {
        return Bennu.getInstance().getDocumentSignersSet().stream();
    }

    public static DocumentSigner findDefaultDocumentSignature() {
        return DocumentSigner.findAll().filter(DocumentSigner::isDefaultSignature).findFirst().orElse(null);
    }

    public static DocumentSigner create(AdministrativeOffice administrativeOffice, String string, String string2, LocalizedString localizedString, LocalizedString localizedString2, Gender gender) {
        return (DocumentSigner)((Object)advice$create.perform((Callable)new DocumentSigner$callable$create(administrativeOffice, string, string2, localizedString, localizedString2, gender)));
    }

    static /* synthetic */ DocumentSigner advised$create(AdministrativeOffice administrativeOffice, String responsibleName, String responsibleShortName, LocalizedString responsibleFunction, LocalizedString responsibleUnit, Gender responsibleGender) {
        return new DocumentSigner(administrativeOffice, responsibleName, responsibleShortName, responsibleFunction, responsibleUnit, responsibleGender);
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        DEFAULT_COMPARATOR = new Comparator<DocumentSigner>(){

            @Override
            public int compare(DocumentSigner ds1, DocumentSigner ds2) {
                if (ds1.isDefaultSignature()) {
                    return -1;
                }
                if (ds2.isDefaultSignature()) {
                    return 1;
                }
                return ds1.getResponsibleName().compareTo(ds2.getResponsibleName());
            }
        };
    }
}

