/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.solution.fenixedu.integration.cgd.webservices.messages.member;

import com.qubit.solution.fenixedu.integration.cgd.webservices.resolver.memberid.IMemberIDAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.TeacherCategory;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.treasury.util.FiscalCodeValidation;
import org.fenixedu.treasury.util.TreasuryConstants;

public class SearchMemberOutputData
implements Serializable {
    private String populationCode;
    private String memberID;
    private String name;
    private String studentNumber;
    private String degreeCode;
    private String degreeName;
    private String degreeType;
    private Integer degreeDuration;
    private Integer curricularYear;
    private String teacherCategory;
    private String teacherNumber;
    private String establishmentCode;
    private String establishmentName;
    private String stayingIndicator;
    private long fiscalCode;

    public String getPopulationCode() {
        return this.populationCode;
    }

    public void setPopulationCode(String populationCode) {
        this.populationCode = populationCode;
    }

    public String getMemberID() {
        return this.memberID;
    }

    public void setMemberID(String memberID) {
        this.memberID = memberID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStudentNumber() {
        return this.studentNumber;
    }

    public void setStudentNumber(String studentNumber) {
        this.studentNumber = studentNumber;
    }

    public String getDegreeCode() {
        return this.degreeCode;
    }

    public void setDegreeCode(String degreeCode) {
        this.degreeCode = degreeCode;
    }

    public String getDegreeName() {
        return this.degreeName;
    }

    public void setDegreeName(String degreeName) {
        this.degreeName = degreeName;
    }

    public String getDegreeType() {
        return this.degreeType;
    }

    public void setDegreeType(String degreeType) {
        this.degreeType = degreeType;
    }

    public Integer getDegreeDuration() {
        return this.degreeDuration;
    }

    public void setDegreeDuration(Integer degreeDuration) {
        this.degreeDuration = degreeDuration;
    }

    public Integer getCurricularYear() {
        return this.curricularYear;
    }

    public void setCurricularYear(Integer curricularYear) {
        this.curricularYear = curricularYear;
    }

    public String getTeacherCategory() {
        return this.teacherCategory;
    }

    public void setTeacherCategory(String teacherCategory) {
        this.teacherCategory = teacherCategory;
    }

    public String getTeacherNumber() {
        return this.teacherNumber;
    }

    public void setTeacherNumber(String teacherNumber) {
        this.teacherNumber = teacherNumber;
    }

    public String getEstablishmentCode() {
        return this.establishmentCode;
    }

    public void setEstablishmentCode(String establishmentCode) {
        this.establishmentCode = establishmentCode;
    }

    public String getEstablishmentName() {
        return this.establishmentName;
    }

    public void setEstablishmentName(String establishmentName) {
        this.establishmentName = establishmentName;
    }

    public String getStayingIndicator() {
        return this.stayingIndicator;
    }

    public void setStayingIndicator(String stayingIndicator) {
        this.stayingIndicator = stayingIndicator;
    }

    public long getFiscalCode() {
        return this.fiscalCode;
    }

    public void setFiscalCode(long fiscalCode) {
        this.fiscalCode = fiscalCode;
    }

    public static SearchMemberOutputData createDefault(IMemberIDAdapter strategy, Person person) {
        SearchMemberOutputData searchMemberOutputData = new SearchMemberOutputData();
        searchMemberOutputData.setMemberID(strategy.retrieveMemberID(person));
        searchMemberOutputData.setName(person.getName());
        String socialSecurityNumber = PersonCustomer.fiscalNumber((Person)person);
        String fiscalCountry = PersonCustomer.addressCountryCode((Person)person);
        if (socialSecurityNumber != null && TreasuryConstants.isDefaultCountry((String)fiscalCountry) && FiscalCodeValidation.isValidFiscalNumber((String)fiscalCountry, (String)socialSecurityNumber)) {
            searchMemberOutputData.setFiscalCode(Long.valueOf(socialSecurityNumber));
        } else {
            searchMemberOutputData.setFiscalCode(0L);
        }
        Unit institutionUnit = Bennu.getInstance().getInstitutionUnit();
        searchMemberOutputData.setEstablishmentName(institutionUnit.getName());
        searchMemberOutputData.setEstablishmentCode(institutionUnit.getCode());
        ExecutionYear readCurrentExecutionYear = ExecutionYear.readCurrentExecutionYear();
        ExecutionYear previousYear = readCurrentExecutionYear.getPreviousExecutionYear();
        ArrayList semesters = new ArrayList();
        semesters.addAll(readCurrentExecutionYear.getExecutionPeriodsSet());
        semesters.addAll(previousYear.getExecutionPeriodsSet());
        String stayingIndicator = person.getStudent() != null && person.getStudent().hasActiveRegistrations() || person.getTeacher() != null && person.getTeacher().getTeacherAuthorizationStream().anyMatch(authorization -> semesters.contains(authorization.getExecutionInterval())) ? "S" : "N";
        searchMemberOutputData.setStayingIndicator(stayingIndicator);
        return searchMemberOutputData;
    }

    public static SearchMemberOutputData createStudentBased(IMemberIDAdapter strategy, Registration registration) {
        Student student = registration.getStudent();
        Person person = registration.getPerson();
        SearchMemberOutputData searchMemberOutputData = SearchMemberOutputData.createDefault(strategy, person);
        searchMemberOutputData.setPopulationCode("A");
        searchMemberOutputData.setStudentNumber(String.valueOf(student.getNumber()));
        searchMemberOutputData.setStudentNumber(String.valueOf(student.getNumber()));
        searchMemberOutputData.setDegreeCode(registration.getDegree().getMinistryCode());
        searchMemberOutputData.setDegreeName(registration.getDegree().getIdCardName());
        searchMemberOutputData.setCurricularYear(registration.getCurricularYear());
        List degreeCurricularPlansForYear = registration.getDegree().getDegreeCurricularPlansForYear(ExecutionYear.readCurrentExecutionYear());
        if (!degreeCurricularPlansForYear.isEmpty()) {
            searchMemberOutputData.setDegreeDuration(((DegreeCurricularPlan)degreeCurricularPlansForYear.iterator().next()).getDurationInYears());
        }
        searchMemberOutputData.setDegreeType(registration.getDegree().getDegreeType().getName().getContent());
        return searchMemberOutputData;
    }

    public static SearchMemberOutputData createTeacherBased(IMemberIDAdapter strategy, Teacher teacher) {
        Person person = teacher.getPerson();
        SearchMemberOutputData searchMemberOutputData = SearchMemberOutputData.createDefault(strategy, person);
        searchMemberOutputData.setPopulationCode("D");
        TeacherCategory category = teacher.getCategory();
        if (category != null) {
            String content = category.getName().getContent();
            if (content.length() > 23) {
                content = content.substring(0, 23);
            }
            searchMemberOutputData.setTeacherCategory(content);
        }
        searchMemberOutputData.setTeacherNumber(teacher.getTeacherId());
        return searchMemberOutputData;
    }

    public static SearchMemberOutputData createEmployeeBased(IMemberIDAdapter strategy, Person person) {
        SearchMemberOutputData searchMemberOutputData = SearchMemberOutputData.createDefault(strategy, person);
        searchMemberOutputData.setPopulationCode("F");
        searchMemberOutputData.setTeacherCategory("");
        searchMemberOutputData.setTeacherNumber(person.getUsername());
        return searchMemberOutputData;
    }
}

