/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.solution.fenixedu.integration.cgd.webservices.messages.member;

import com.qubit.solution.fenixedu.integration.cgd.webservices.messages.CgdMessageUtils;
import com.qubit.solution.fenixedu.integration.cgd.webservices.messages.member.SearchMemberOutputData;
import com.qubit.solution.fenixedu.integration.cgd.webservices.resolver.memberid.IMemberIDAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.bennu.core.groups.DynamicGroup;

public class SearchMemberOutput
implements Serializable {
    private int replyCode;
    private List<SearchMemberOutputData> memberInfo;

    public SearchMemberOutput() {
        this.setMemberInfo(Collections.EMPTY_LIST);
        this.setReplyCode(CgdMessageUtils.REPLY_CODE_UNEXISTING_MEMBER);
    }

    public int getReplyCode() {
        return this.replyCode;
    }

    public void setReplyCode(int replyCode) {
        this.replyCode = replyCode;
    }

    public List<SearchMemberOutputData> getMemberInfo() {
        return this.memberInfo;
    }

    public void setMemberInfo(List<SearchMemberOutputData> memberInfo) {
        this.memberInfo = memberInfo;
    }

    public void populate(Person person, String populationCode, String memberCode, String memberID) {
        if (person != null) {
            this.setReplyCode(CgdMessageUtils.REPLY_CODE_OPERATION_OK);
            IMemberIDAdapter memberIDStrategy = CgdMessageUtils.getMemberIDStrategy();
            ArrayList<SearchMemberOutputData> list = new ArrayList<SearchMemberOutputData>();
            ExecutionYear readCurrentExecutionYear = ExecutionYear.readCurrentExecutionYear();
            ExecutionYear previousYear = readCurrentExecutionYear.getPreviousExecutionYear();
            if (person.getStudent() != null && !person.getStudent().getActiveRegistrations().isEmpty()) {
                for (Registration registration : person.getStudent().getActiveRegistrations()) {
                    if (registration.getEnrolments(readCurrentExecutionYear).isEmpty() && registration.getEnrolments(previousYear).isEmpty()) continue;
                    list.add(SearchMemberOutputData.createStudentBased(memberIDStrategy, registration));
                }
            }
            ArrayList semesters = new ArrayList();
            semesters.addAll(readCurrentExecutionYear.getExecutionPeriodsSet());
            semesters.addAll(previousYear.getExecutionPeriodsSet());
            if (person.getTeacher() != null && person.getTeacher().getTeacherAuthorizationStream().anyMatch(authorization -> semesters.contains(authorization.getExecutionInterval()))) {
                list.add(SearchMemberOutputData.createTeacherBased(memberIDStrategy, person.getTeacher()));
            }
            if (DynamicGroup.get((String)"employees").isMember(person.getUser())) {
                list.add(SearchMemberOutputData.createEmployeeBased(memberIDStrategy, person));
            }
            if (list.isEmpty()) {
                SearchMemberOutputData createDefault = SearchMemberOutputData.createDefault(memberIDStrategy, person);
                if (!StringUtils.isEmpty((String)populationCode)) {
                    switch (populationCode.charAt(0)) {
                        case 'A': {
                            Student student = person.getStudent();
                            if (student == null) break;
                            createDefault.setPopulationCode("A");
                            createDefault.setStudentNumber(String.valueOf(student.getNumber()));
                            break;
                        }
                        case 'D': {
                            Teacher teacher = person.getTeacher();
                            if (teacher == null) break;
                            createDefault.setPopulationCode("D");
                            String content = teacher.getCategory().getName().getContent();
                            if (content.length() > 23) {
                                content = content.substring(0, 23);
                            }
                            createDefault.setTeacherCategory(content);
                            createDefault.setTeacherNumber(teacher.getTeacherId());
                            break;
                        }
                        case 'F': {
                            boolean member = DynamicGroup.get((String)"employees").isMember(person.getUser());
                            if (!member) break;
                            createDefault.setPopulationCode("F");
                            createDefault.setTeacherNumber(person.getUsername());
                        }
                    }
                }
                list.add(createDefault);
            }
            this.setMemberInfo(list);
        }
    }
}

