/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.solution.fenixedu.integration.cgd.webservices.messages.member;

import com.qubit.solution.fenixedu.integration.cgd.domain.configuration.CgdIntegrationConfiguration;
import com.qubit.solution.fenixedu.integration.cgd.webservices.messages.CgdMessageUtils;
import java.io.Serializable;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.person.IDDocumentType;

public class SearchMemberInput
implements Serializable {
    private static int IDCARD_TYPE = 101;
    private static int TAXNUMBER_TYPE = 501;
    private String populationCode;
    private String memberID;
    private Integer documentType;
    private String documentID;
    private String memberCode;

    public Integer getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(Integer documentType) {
        this.documentType = documentType;
    }

    public String getDocumentID() {
        return this.documentID != null ? this.documentID.trim() : this.documentID;
    }

    public void setDocumentID(String documentID) {
        this.documentID = documentID;
    }

    public String getPopulationCode() {
        return this.populationCode != null ? this.populationCode.trim() : this.populationCode;
    }

    public void setPopulationCode(String populationCode) {
        this.populationCode = populationCode;
    }

    public String getMemberID() {
        return this.memberID != null ? this.memberID.trim() : this.memberID;
    }

    public void setMemberID(String memberID) {
        this.memberID = memberID;
    }

    public String getMemberCode() {
        return this.memberCode != null ? this.memberCode.trim() : this.memberCode;
    }

    public void setMemberCode(String memberCode) {
        this.memberCode = memberCode;
    }

    public Person getIdentifiedPerson() {
        Person requestedPerson = null;
        if (!StringUtils.isEmpty((String)this.getMemberID())) {
            requestedPerson = CgdIntegrationConfiguration.getInstance().getMemberIDStrategy().readPerson(this.getMemberID());
        }
        if (requestedPerson == null) {
            String defaultSocialSecurityNumber;
            if (this.documentType != null && this.documentType == IDCARD_TYPE) {
                requestedPerson = Person.readByDocumentIdNumberAndIdDocumentType((String)this.getDocumentID(), (IDDocumentType)IDDocumentType.CITIZEN_CARD);
                if (requestedPerson == null) {
                    requestedPerson = Person.readByDocumentIdNumberAndIdDocumentType((String)this.getDocumentID(), (IDDocumentType)IDDocumentType.IDENTITY_CARD);
                }
                if (requestedPerson == null) {
                    Collection people = Person.readByDocumentIdNumber((String)this.getDocumentID());
                    requestedPerson = people.isEmpty() ? null : (Person)people.iterator().next();
                }
            } else if (!(this.documentType == null || this.documentType != TAXNUMBER_TYPE || (defaultSocialSecurityNumber = FenixEduAcademicConfiguration.getConfiguration().getDefaultSocialSecurityNumber()) != null && defaultSocialSecurityNumber.equals(this.documentID))) {
                Party party = Person.readByContributorNumber((String)this.documentID);
                Person person = requestedPerson = party instanceof Person ? (Person)party : null;
            }
        }
        if (requestedPerson == null && !StringUtils.isEmpty((String)this.getMemberCode())) {
            requestedPerson = CgdMessageUtils.readPersonByMemberCode(this.getPopulationCode(), this.getMemberCode());
        }
        return requestedPerson;
    }
}

