/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.solution.fenixedu.integration.cgd.webservices;

import com.qubit.solution.fenixedu.bennu.webservices.services.server.BennuWebService;
import com.qubit.solution.fenixedu.integration.cgd.services.form43.CgdForm43Sender;
import com.qubit.solution.fenixedu.integration.cgd.webservices.ReceiveMifareService$callable$createCgdCard;
import com.qubit.solution.fenixedu.integration.cgd.webservices.ReceiveMifareService$callable$updateCgdCard;
import com.qubit.solution.fenixedu.integration.cgd.webservices.messages.CgdMessageUtils;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;
import org.datacontract.schemas._2004._07.wcfservice2.ErrorCode;
import org.datacontract.schemas._2004._07.wcfservice2.Status;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.ulisboa.specifications.domain.idcards.CgdCard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;
import receveivemifareservice.IGenericService;
import response.genericwebservice.ObjectFactory;
import response.genericwebservice.Response;

@WebService
public class ReceiveMifareService
extends BennuWebService
implements IGenericService {
    private static Logger logger;
    private static String IES_CODE;
    ObjectFactory objectFactory = new ObjectFactory();
    public static final Advice advice$updateCgdCard;
    public static final Advice advice$createCgdCard;

    private String getIESCode() {
        if (IES_CODE == null) {
            IES_CODE = new CgdForm43Sender().getSchooldIESCode();
        }
        return IES_CODE;
    }

    @Override
    @WebMethod(operationName="ReceiveMifare", action="http://ReceveiveMifareService/IGenericService/ReceiveMifare")
    @WebResult(name="ReceiveMifareResult", targetNamespace="http://ReceveiveMifareService")
    @RequestWrapper(localName="ReceiveMifare", targetNamespace="http://ReceveiveMifareService", className="receveivemifareservice.ReceiveMifare")
    @ResponseWrapper(localName="ReceiveMifareResponse", targetNamespace="http://ReceveiveMifareService", className="receveivemifareservice.ReceiveMifareResponse")
    public Response receiveMifare(@WebParam(name="Mifare", targetNamespace="http://ReceveiveMifareService") String mifare, @WebParam(name="MemberNumber", targetNamespace="http://ReceveiveMifareService") String memberNumber, @WebParam(name="memberCategoryCode", targetNamespace="http://ReceveiveMifareService") String memberCategoryCode, @WebParam(name="IES", targetNamespace="http://ReceveiveMifareService") String iesCode) {
        Response response = new Response();
        if (this.getIESCode() != null && !this.getIESCode().equals(iesCode)) {
            response.setStatus(Status.NOK);
            response.setErrorCode(ErrorCode.INVALID_DATA);
            response.setErrorDescription(this.objectFactory.createResponseErrorDescription("Wrong iesCode, expected: " + this.getIESCode() + " received " + iesCode));
        } else {
            try {
                Person readPerson = CgdMessageUtils.getMemberIDStrategy().readPerson(memberNumber);
                if (readPerson == null) {
                    response.setStatus(Status.NOK);
                    response.setErrorCode(ErrorCode.INVALID_DATA);
                    response.setErrorDescription(this.objectFactory.createResponseErrorDescription("No member with identification: " + memberNumber));
                } else {
                    CgdCard card = CgdCard.findByPerson((Person)readPerson);
                    if (card != null) {
                        this.updateCgdCard(card, mifare);
                    } else {
                        this.createCgdCard(readPerson, mifare);
                    }
                    response.setStatus(Status.OK);
                    response.setErrorCode(ErrorCode.NONE);
                }
            }
            catch (Throwable t) {
                logger.error("Problem while receiving temporary mifare", t);
                response.setStatus(Status.NOK);
                response.setErrorCode(ErrorCode.INTERNAL_ERROR);
                response.setErrorDescription(this.objectFactory.createResponseErrorDescription(t.getMessage()));
            }
        }
        return response;
    }

    private void updateCgdCard(CgdCard cgdCard, String string) {
        Object object = advice$updateCgdCard.perform((Callable)new ReceiveMifareService$callable$updateCgdCard(this, cgdCard, string));
    }

    static /* synthetic */ void advised$updateCgdCard(ReceiveMifareService this_, CgdCard card, String mifare) {
        card.setMifareCode(mifare);
    }

    private void createCgdCard(Person person, String string) {
        Object object = advice$createCgdCard.perform((Callable)new ReceiveMifareService$callable$createCgdCard(this, person, string));
    }

    static /* synthetic */ void advised$createCgdCard(ReceiveMifareService this_, Person readPerson, String mifare) {
        new CgdCard(readPerson, mifare, true);
    }

    static {
        advice$updateCgdCard = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createCgdCard = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        logger = LoggerFactory.getLogger(ReceiveMifareService.class);
        IES_CODE = null;
    }
}

