/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.solution.fenixedu.integration.cgd.ui.mifareManagement;

import com.qubit.solution.fenixedu.integration.cgd.ui.CgdBaseController;
import com.qubit.solution.fenixedu.integration.cgd.ui.mifareManagement.CgdCardController$callable$createCgdCard;
import com.qubit.solution.fenixedu.integration.cgd.ui.mifareManagement.CgdCardController$callable$updateCgdCard;
import com.qubit.solution.fenixedu.integration.cgd.ui.mifareManagement.PersonController;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.ulisboa.specifications.domain.idcards.CgdCard;
import org.joda.time.LocalDate;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@BennuSpringController(value=PersonController.class)
@RequestMapping(value={"/cgd/mifaremanagement/cgdcard"})
public class CgdCardController
extends CgdBaseController {
    public static final Advice advice$updateCgdCard = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createCgdCard = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/cgd/mifaremanagement/cgdcard/";
    }

    private CgdCard getCgdCard(Model m) {
        return (CgdCard)m.asMap().get("cgdCard");
    }

    private void setCgdCard(CgdCard cgdCard, Model m) {
        m.addAttribute("cgdCard", (Object)cgdCard);
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") CgdCard cgdCard, Model model) {
        this.setCgdCard(cgdCard, model);
        return "cgd/mifaremanagement/cgdcard/update";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") CgdCard cgdCard, Model model) {
        Person person = cgdCard.getPerson();
        cgdCard.delete();
        return "redirect:/cgd/mifaremanagement/person/readpersonmifare/" + person.getExternalId();
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") CgdCard cgdCard, @RequestParam(value="mifarecode", required=true) String mifareCode, @RequestParam(value="cardNumber", required=false) String cardNumber, @RequestParam(value="validuntil", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate validUntil, @RequestParam(value="temporary", required=true) boolean temporary, Model model) {
        this.setCgdCard(cgdCard, model);
        this.updateCgdCard(mifareCode, cardNumber, validUntil, temporary, model);
        return "redirect:/cgd/mifaremanagement/person/readpersonmifare/" + this.getCgdCard(model).getPerson().getExternalId();
    }

    public void updateCgdCard(String string, String string2, LocalDate localDate, boolean bl, Model model) {
        Object object = advice$updateCgdCard.perform((Callable)new CgdCardController$callable$updateCgdCard(this, string, string2, localDate, bl, model));
    }

    static /* synthetic */ void advised$updateCgdCard(CgdCardController this_, String mifareCode, String cardNumber, LocalDate validUntil, boolean temporary, Model m) {
        CgdCard cgdCard = this_.getCgdCard(m);
        cgdCard.setMifareCode(mifareCode);
        cgdCard.setCardNumber(cardNumber);
        cgdCard.setValidUntil(validUntil);
        cgdCard.setTemporary(temporary);
    }

    @RequestMapping(value={"/create/{oid}"}, method={RequestMethod.GET})
    public String create(@PathVariable(value="oid") Person person, Model model) {
        model.addAttribute("person", (Object)person);
        return "cgd/mifaremanagement/cgdcard/create";
    }

    @RequestMapping(value={"/create/{oid}"}, method={RequestMethod.POST})
    public String create(@PathVariable(value="oid") Person person, @RequestParam(value="mifarecode", required=false) String mifareCode, @RequestParam(value="validuntil", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate validUntil, @RequestParam(value="temporary", required=true) boolean temporary, Model model) {
        Object correctMifareCode = mifareCode;
        if (!StringUtils.isBlank((String)mifareCode) && mifareCode.length() > 4) {
            String possibleLength = mifareCode.substring(0, 4);
            Integer valueOf = Integer.valueOf(possibleLength);
            String possibleCode = mifareCode.substring(4);
            if (possibleCode.length() != valueOf.intValue()) {
                correctMifareCode = StringUtils.leftPad((String)String.valueOf(mifareCode.length()), (int)4, (String)"0") + mifareCode;
            }
        }
        if (StringUtils.isBlank((String)mifareCode)) {
            this.addErrorMessage(BundleUtil.getString((String)"resources/CgdintegrationResources", (String)"label.mifareManagment.cgdCard.cannotBeBlank", (String[])new String[0]), model);
            model.addAttribute("person", (Object)person);
            return "cgd/mifaremanagement/cgdcard/create";
        }
        String mifareCodeToCheck = correctMifareCode;
        if (Bennu.getInstance().getCgdCardsSet().stream().anyMatch(card -> mifareCodeToCheck.equals(card.getMifareCode()))) {
            this.addErrorMessage(BundleUtil.getString((String)"resources/CgdintegrationResources", (String)"label.mifareManagment.cgdCard.duplicate", (String[])new String[]{mifareCodeToCheck}), model);
            model.addAttribute("person", (Object)person);
            return "cgd/mifaremanagement/cgdcard/create";
        }
        CgdCard cgdCard = this.createCgdCard(person, mifareCode, validUntil, temporary);
        model.addAttribute("cgdCard", (Object)cgdCard);
        return "redirect:/cgd/mifaremanagement/person/readpersonmifare/" + person.getExternalId();
    }

    public CgdCard createCgdCard(Person person, String string, LocalDate localDate, boolean bl) {
        return (CgdCard)advice$createCgdCard.perform((Callable)new CgdCardController$callable$createCgdCard(this, person, string, localDate, bl));
    }

    static /* synthetic */ CgdCard advised$createCgdCard(CgdCardController this_, Person person, String mifareCode, LocalDate validUntil, boolean temporary) {
        CgdCard cgdCard = new CgdCard(person, mifareCode, temporary);
        cgdCard.setValidUntil(validUntil);
        return cgdCard;
    }
}

