/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.solution.fenixedu.integration.cgd.webservices.messages.photo;

import com.qubit.solution.fenixedu.integration.cgd.services.CgdAuthorizationCodes;
import com.qubit.solution.fenixedu.integration.cgd.webservices.messages.CgdMessageUtils;
import java.io.Serializable;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Photograph;
import org.fenixedu.academic.domain.photograph.PictureMode;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorization;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorizationType;

public class SearchMemberPhotoOuputMessage
implements Serializable {
    public static int UNAVAILABLE_PHOTO = 8;
    private int replyCode;
    private String name;
    private byte[] photo;

    public SearchMemberPhotoOuputMessage() {
        this.setReplyCode(CgdMessageUtils.REPLY_CODE_UNEXISTING_MEMBER);
    }

    public int getReplyCode() {
        return this.replyCode;
    }

    public void setReplyCode(int replyCode) {
        this.replyCode = replyCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public byte[] getPhoto() {
        return this.photo;
    }

    public void setPhoto(byte[] photo) {
        this.photo = photo;
    }

    public void populate(Person person, String populationCode, String memberCode, String memberID) {
        boolean verifyMatch = CgdMessageUtils.verifyMatch(person, populationCode, memberCode, memberID);
        if (verifyMatch) {
            Photograph personalPhoto = person.getPersonalPhoto();
            DataShareAuthorization photoAuthorization = DataShareAuthorization.findLatest((Person)person, (DataShareAuthorizationType)DataShareAuthorizationType.findUnique((String)CgdAuthorizationCodes.PHOTO));
            if (personalPhoto == null || photoAuthorization == null || !photoAuthorization.getAllow().booleanValue()) {
                this.setReplyCode(UNAVAILABLE_PHOTO);
                this.setName(person.getName());
            } else {
                this.setReplyCode(CgdMessageUtils.REPLY_CODE_OPERATION_OK);
                this.setName(person.getName());
                byte[] customAvatar = personalPhoto.getCustomAvatar(180, 180, PictureMode.FIT);
                this.setPhoto(personalPhoto.exportAsJPEG(customAvatar));
            }
        } else {
            this.setReplyCode(CgdMessageUtils.REPLY_CODE_INFORMATION_NOT_OK);
        }
    }
}

