/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.solution.fenixedu.integration.cgd.webservices.messages;

import com.qubit.solution.fenixedu.integration.cgd.domain.configuration.CgdIntegrationConfiguration;
import com.qubit.solution.fenixedu.integration.cgd.webservices.resolver.memberid.IMemberIDAdapter;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.bennu.core.groups.DynamicGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgdMessageUtils {
    private static Logger logger = LoggerFactory.getLogger(CgdMessageUtils.class);
    public static int REPLY_CODE_OPERATION_OK = 0;
    public static int REPLY_CODE_INFORMATION_NOT_OK = 1;
    public static int REPLY_CODE_UNEXISTING_MEMBER = 9;

    public static Person readPersonByMemberCode(String populationCode, String memberCode) {
        Person requestedPerson = null;
        if (!StringUtils.isEmpty((String)memberCode) && !StringUtils.isEmpty((String)populationCode)) {
            switch (populationCode.charAt(0)) {
                case 'A': {
                    Student student = null;
                    try {
                        int number = Integer.parseInt(memberCode);
                        student = Student.readStudentByNumber((Integer)number);
                    }
                    catch (Exception e) {
                        logger.warn(String.format("Invalid student number: [%s]", memberCode));
                    }
                    if (student != null) {
                        requestedPerson = student.getPerson();
                    }
                }
                case 'E': {
                    break;
                }
                case 'D': {
                    Teacher teacher;
                    List readByNumbers = Teacher.readByNumbers(Collections.singleton(memberCode));
                    Teacher teacher2 = teacher = readByNumbers.isEmpty() ? null : (Teacher)readByNumbers.iterator().next();
                    if (teacher == null) break;
                    requestedPerson = teacher.getPerson();
                }
            }
        }
        return requestedPerson;
    }

    public static boolean verifyMatch(Person person, String populationCode, String memberCode, String memberID) {
        boolean matchOk;
        boolean bl = matchOk = StringUtils.isEmpty((String)populationCode) || StringUtils.isEmpty((String)memberCode);
        if (!matchOk) {
            switch (populationCode.charAt(0)) {
                case 'A': {
                    matchOk = person.getStudent() != null && String.valueOf(person.getStudent().getNumber()).equals(memberCode);
                    break;
                }
                case 'F': {
                    matchOk = DynamicGroup.get((String)"employees").isMember(person.getUser());
                    break;
                }
                case 'D': {
                    boolean bl2 = matchOk = person.getTeacher() != null && person.getTeacher().getTeacherId().equals(memberCode);
                }
            }
        }
        if (matchOk && !StringUtils.isEmpty((String)memberID)) {
            matchOk = memberID.equals(CgdMessageUtils.getMemberIDStrategy().retrieveMemberID(person));
        }
        return matchOk;
    }

    public static IMemberIDAdapter getMemberIDStrategy() {
        return CgdIntegrationConfiguration.getInstance().getMemberIDStrategy();
    }
}

