/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.solution.fenixedu.integration.cgd.ui.mifareManagement;

import com.qubit.solution.fenixedu.integration.cgd.ui.CgdBaseController;
import com.qubit.solution.fenixedu.integration.cgd.ui.CgdController;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.ulisboa.specifications.domain.idcards.CgdCard;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@SpringFunctionality(app=CgdController.class, title="label.title.mifareManagement", accessGroup="#managers | #cgdCollaborators")
@RequestMapping(value={"/cgd/mifaremanagement/person"})
public class PersonController
extends CgdBaseController {
    @RequestMapping
    public String home(Model model) {
        return "forward:/cgd/mifaremanagement/person/";
    }

    private void setPerson(Person person, Model m) {
        m.addAttribute("person", (Object)person);
    }

    private Person getPerson(Model m) {
        return (Person)m.asMap().get("person");
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="name", required=false, defaultValue="") String name, @RequestParam(value="username", required=false) String username, @RequestParam(value="documentidnumber", required=false) String documentIdNumber, @RequestParam(value="mifareCode", required=false) String mifareCode, Model model) {
        List<Person> searchpersonResultsDataSet = this.filterSearchPerson(name, username, documentIdNumber, mifareCode);
        model.addAttribute("searchpersonResultsDataSet", searchpersonResultsDataSet);
        return "cgd/mifaremanagement/person/search";
    }

    private List<Person> filterSearchPerson(String name, String username, String documentIdNumber, String mifareCode) {
        if (StringUtils.isEmpty((String)name) && StringUtils.isEmpty((String)username) && StringUtils.isEmpty((String)documentIdNumber) && StringUtils.isEmpty((String)mifareCode)) {
            return Collections.emptyList();
        }
        Stream stream = StringUtils.isEmpty((String)name) ? Party.readAllPersons().stream() : Person.findPersonStream((String)name, (int)Integer.MAX_VALUE);
        return stream.filter(person -> StringUtils.isEmpty((String)username) || username.equals(person.getUsername())).filter(person -> StringUtils.isEmpty((String)documentIdNumber) || documentIdNumber.equals(person.getDocumentIdNumber())).filter(person -> StringUtils.isEmpty((String)mifareCode) || CgdCard.findByPerson((Person)person) != null && mifareCode.equals(CgdCard.findByPerson((Person)person).getMifareCode())).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") Person person, Model model) {
        return "redirect:/cgd/mifaremanagement/person/readpersonmifare/" + person.getExternalId();
    }

    @RequestMapping(value={"/readpersonmifare/{oid}"})
    public String readpersonmifare(@PathVariable(value="oid") Person person, Model model) {
        this.setPerson(person, model);
        return "cgd/mifaremanagement/person/readpersonmifare";
    }

    @RequestMapping(value={"/readpersonmifare/{oid}/createmifarecard"})
    public String processReadpersonmifareToCreateMifareCard(@PathVariable(value="oid") Person person, Model model) {
        this.setPerson(person, model);
        return "redirect:/cgd/mifaremanagement/cgdcard/create/" + this.getPerson(model).getExternalId();
    }
}

