/*
 * Decompiled with CFR 0.152.
 */
package com.qubit.solution.fenixedu.integration.cgd.services.form43;

import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.microsoft.schemas._2003._10.serialization.arrays.ArrayOfstring;
import com.qubit.solution.fenixedu.bennu.webservices.services.client.BennuWebServiceClient;
import com.qubit.solution.fenixedu.integration.cgd.domain.configuration.CgdIntegrationConfiguration;
import com.qubit.solution.fenixedu.integration.cgd.services.CgdAuthorizationCodes;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.ws.BindingProvider;
import org.apache.commons.lang.StringUtils;
import org.datacontract.schemas._2004._07.wingman_cgd_caixaiu_datacontract.School;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.ProfessionalSituationConditionType;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.person.MaritalStatus;
import org.fenixedu.academic.domain.student.PersonalIngressionData;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorization;
import org.fenixedu.academicextensions.domain.person.dataShare.DataShareAuthorizationType;
import org.fenixedu.academictreasury.domain.customer.PersonCustomer;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.YearMonthDay;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import services.caixaiu.cgd.wingman.iesservice.ArrayOfValidationResult;
import services.caixaiu.cgd.wingman.iesservice.Client;
import services.caixaiu.cgd.wingman.iesservice.Form43Digital;
import services.caixaiu.cgd.wingman.iesservice.IESService;
import services.caixaiu.cgd.wingman.iesservice.IIESService;
import services.caixaiu.cgd.wingman.iesservice.IdentificationCard;
import services.caixaiu.cgd.wingman.iesservice.ObjectFactory;
import services.caixaiu.cgd.wingman.iesservice.OperationResult;
import services.caixaiu.cgd.wingman.iesservice.Student;
import services.caixaiu.cgd.wingman.iesservice.ValidationResult;
import services.caixaiu.cgd.wingman.iesservice.Worker;

public class CgdForm43Sender
extends BennuWebServiceClient<IIESService> {
    private static ObjectFactory objectFactory = new ObjectFactory();
    private static Logger logger = LoggerFactory.getLogger(CgdForm43Sender.class);

    protected BindingProvider getService() {
        return (BindingProvider)new IESService().getBasicHttpBindingIIESService();
    }

    public boolean sendForm43For(Registration registration) {
        return this.sendForm43For(registration, true);
    }

    public boolean sendForm43For(Registration registration, boolean requestCard) {
        IIESService service = (IIESService)this.getClient();
        boolean success = false;
        try {
            Person person = registration.getStudent().getPerson();
            Client clientData = CgdForm43Sender.createClient(person, service);
            services.caixaiu.cgd.wingman.iesservice.Person personData = CgdForm43Sender.createPerson(person);
            Worker workerData = CgdForm43Sender.createWorker(person);
            Student studentData = CgdForm43Sender.createStudent(registration);
            Form43Digital form43Digital = new Form43Digital();
            form43Digital.setClientData(clientData);
            form43Digital.setPersonData(personData);
            form43Digital.setProfessionalData(workerData);
            form43Digital.setStudentData(studentData);
            form43Digital.setIDCardProduction(requestCard);
            OperationResult setForm43DigitalData = service.setForm43DigitalData(form43Digital);
            boolean bl = success = setForm43DigitalData.isError() == false;
            if (!success) {
                logger.info("Problems while trying to send form 43 to student with number: " + registration.getStudent().getNumber() + "with message: " + (String)setForm43DigitalData.getFriendlyMessage().getValue() + "\nCode id: " + setForm43DigitalData.getCodeId() + "\n Unique Error ID: " + setForm43DigitalData.getUEC() + "\n In case there are violations they'll be present bellow ");
                for (ValidationResult validation : ((ArrayOfValidationResult)setForm43DigitalData.getViolations().getValue()).getValidationResult()) {
                    logger.error("Validation error : " + (String)validation.getErrorMessage().getValue() + " [member: " + ((ArrayOfstring)validation.getMemberNames().getValue()).getString().toString() + "]");
                }
            } else {
                logger.info("Sent successfuly form 43 for student with number:" + registration.getStudent().getNumber());
            }
        }
        catch (Throwable t) {
            logger.warn("Problems while trying to send form43 for student with number: " + registration.getStudent().getNumber(), t);
        }
        return success;
    }

    private static String getInstitutionCode() {
        String code = Bennu.getInstance().getInstitutionUnit().getCode();
        return code;
    }

    private static Client createClient(Person person, IIESService service) {
        Client client = new Client();
        String findIES = CgdForm43Sender.findIES(CgdForm43Sender.getInstitutionCode(), service);
        CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.BASIC_INFO, () -> {
            client.setIES(findIES);
            client.setGroup(objectFactory.createClientGroup("1"));
            client.setMemberCategoryCode("91");
            String retrieveMemberID = CgdIntegrationConfiguration.getInstance().getMemberIDStrategy().retrieveMemberID(person);
            client.setMemberNumber(retrieveMemberID);
        });
        return client;
    }

    private static Worker createWorker(Person person) {
        Worker worker = new Worker();
        CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_WORKING_INFO, () -> {
            worker.setIsWorker(person.getStudent().hasWorkingStudentStatuteInPeriod((ExecutionInterval)ExecutionYear.readCurrentExecutionYear()));
            PersonalIngressionData personalIngressionDataByExecutionYear = person.getStudent().getPersonalIngressionDataByExecutionYear(ExecutionYear.readCurrentExecutionYear());
            if (personalIngressionDataByExecutionYear != null) {
                worker.setSituationCode(objectFactory.createWorkerSituationCode(CgdForm43Sender.getCodeForProfessionalCondition(personalIngressionDataByExecutionYear.getProfessionalCondition())));
            }
        });
        CgdForm43Sender.executeIfAllowed(person, "EXTENDED_INFO_FISCAL_COUNTRY", () -> worker.setFiscalCountryCode(objectFactory.createWorkerFiscalCountryCode(PersonCustomer.addressCountryCode((Person)person))));
        return worker;
    }

    private static String getCodeForProfessionalCondition(ProfessionalSituationConditionType professionalCondition) {
        if (professionalCondition == null) {
            professionalCondition = ProfessionalSituationConditionType.UNKNOWN;
        }
        switch (professionalCondition) {
            case WORKS_FOR_OTHERS: {
                return "1";
            }
            case EMPLOYEER: 
            case INDEPENDENT_WORKER: {
                return "2";
            }
        }
        return "3";
    }

    private static void executeIfAllowed(Person person, String dataShareQuestionCode, Runnable executeIfAuthorized) {
        if (dataShareQuestionCode.equals(CgdAuthorizationCodes.BASIC_INFO)) {
            executeIfAuthorized.run();
        } else {
            DataShareAuthorization authorization = DataShareAuthorization.findLatest((Person)person, (DataShareAuthorizationType)DataShareAuthorizationType.findUnique((String)dataShareQuestionCode));
            if (authorization != null && authorization.getAllow().booleanValue()) {
                executeIfAuthorized.run();
            }
        }
    }

    private static services.caixaiu.cgd.wingman.iesservice.Person createPerson(Person person) {
        services.caixaiu.cgd.wingman.iesservice.Person personData = new services.caixaiu.cgd.wingman.iesservice.Person();
        CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.BASIC_INFO, () -> personData.setName(person.getName()));
        CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_EMAIL, () -> personData.setEmail(objectFactory.createPersonEmail(person.getInstitutionalEmailAddressValue())));
        CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_GENDER, () -> personData.setGenderCode(objectFactory.createPersonGenderCode(CgdForm43Sender.getCodeForGender(person.getGender()))));
        YearMonthDay dateOfBirthYearMonthDay = person.getDateOfBirthYearMonthDay();
        if (dateOfBirthYearMonthDay != null) {
            CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.BASIC_INFO, () -> {
                try {
                    personData.setBirthDate(DatatypeFactory.newInstance().newXMLGregorianCalendar(dateOfBirthYearMonthDay.toDateTimeAtMidnight().toGregorianCalendar()));
                }
                catch (DatatypeConfigurationException e) {
                    e.printStackTrace();
                }
            });
        }
        CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.BASIC_INFO, () -> personData.setFiscalNumber(objectFactory.createPersonFiscalNumber(person.getSocialSecurityNumber())));
        PersonalIngressionData personalIngressionDataByExecutionYear = person.getStudent().getPersonalIngressionDataByExecutionYear(ExecutionYear.readCurrentExecutionYear());
        if (personalIngressionDataByExecutionYear != null) {
            MaritalStatus maritalStatus = personalIngressionDataByExecutionYear.getMaritalStatus();
            CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_MARITAL_STATUS, () -> personData.setMaritalStatusCode(objectFactory.createPersonMaritalStatusCode(CgdForm43Sender.getCodeForMaritalStatus(maritalStatus))));
        }
        CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_FATHER_NAME, () -> personData.setFather(objectFactory.createPersonFather(CgdForm43Sender.getShortNameFor(person.getNameOfFather()))));
        CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_MOTHER_NAME, () -> personData.setMother(objectFactory.createPersonMother(CgdForm43Sender.getShortNameFor(person.getNameOfMother()))));
        if (person.getCountryOfBirth() != null) {
            CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_BIRTH_COUNTRY, () -> personData.setPlaceOfBirthCountryCode(objectFactory.createPersonPlaceOfBirthCountryCode(person.getCountryOfBirth().getCode())));
        }
        CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_BIRTH_DISTRICT, () -> personData.setPlaceOfBirthDistrict(objectFactory.createPersonPlaceOfBirthDistrict(person.getDistrictOfBirth())));
        CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_BIRTH_COUNTY, () -> personData.setPlaceOfBirthCounty(objectFactory.createPersonPlaceOfBirthCounty(person.getDistrictSubdivisionOfBirth())));
        CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_BIRTH_PARISH, () -> personData.setPlaceOfBirthParish(objectFactory.createPersonPlaceOfBirthParish(person.getParishOfBirth())));
        ArrayOfstring nationality = new ArrayOfstring();
        nationality.getString().add(person.getCountry().getCode());
        Country countryOfResidence = person.getCountryOfResidence();
        CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.BASIC_INFO, () -> {
            personData.setNationalities(nationality);
            if (countryOfResidence != null) {
                personData.setCountryOfResidenceCode(objectFactory.createPersonCountryOfResidenceCode(countryOfResidence.getCode()));
            } else {
                personData.setCountryOfResidenceCode(objectFactory.createPersonCountryOfResidenceCode("PT"));
            }
        });
        PhysicalAddress defaultPhysicalAddress = person.getDefaultPhysicalAddress();
        if (defaultPhysicalAddress != null) {
            CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_ADDRESS_PLACE, () -> {
                personData.setAddress(objectFactory.createPersonAddress(defaultPhysicalAddress.getAddress()));
                personData.setPlace(objectFactory.createPersonPlace(defaultPhysicalAddress.getArea()));
            });
            CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_ADDRESS_POSTAL_CODE, () -> personData.setPostalCode(objectFactory.createPersonPostalCode(defaultPhysicalAddress.getAreaCode())));
            CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_ADDRESS_DISTRICT, () -> personData.setDistrict(objectFactory.createPersonDistrict(defaultPhysicalAddress.getDistrictOfResidence())));
            CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_ADDRESS_POSTAL_COUNTY, () -> personData.setCounty(objectFactory.createPersonCounty(defaultPhysicalAddress.getDistrictSubdivisionOfResidence())));
            CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_ADDRESS_POSTAL_PARISH, () -> personData.setParish(objectFactory.createPersonParish(defaultPhysicalAddress.getParishOfResidence())));
        }
        CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_PHONE, () -> personData.setPhone(objectFactory.createPersonPhone(CgdForm43Sender.getPhoneNumberWithoutCountryCode(person.getDefaultPhoneNumber()))));
        CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_MOBILE_PHONE, () -> personData.setMobilePhone(objectFactory.createPersonMobilePhone(CgdForm43Sender.getPhoneNumberWithoutCountryCode(person.getDefaultMobilePhoneNumber()))));
        IdentificationCard card = new IdentificationCard();
        String codeForDocumentType = CgdForm43Sender.getCodeForDocumentType(person.getIdDocumentType());
        if (codeForDocumentType != null) {
            card.setTypeCode(objectFactory.createIdentificationCardTypeCode(codeForDocumentType));
        }
        card.setNumber(person.getDocumentIdNumber());
        CgdForm43Sender.executeIfAllowed(person, CgdAuthorizationCodes.EXTENDED_INFO_ID_CARD_EXPIRATION_DATE, () -> {
            try {
                YearMonthDay expirationDateOfDocumentIdYearMonthDay = person.getExpirationDateOfDocumentIdYearMonthDay();
                if (expirationDateOfDocumentIdYearMonthDay != null) {
                    card.setExpirationDate(objectFactory.createIdentificationCardExpirationDate(DatatypeFactory.newInstance().newXMLGregorianCalendar(expirationDateOfDocumentIdYearMonthDay.toDateTimeAtMidnight().toGregorianCalendar())));
                }
            }
            catch (DatatypeConfigurationException e) {
                e.printStackTrace();
            }
        });
        personData.setIdentificationCard(objectFactory.createIdentificationCard(card));
        return personData;
    }

    private static String getPhoneNumberWithoutCountryCode(String phoneNumber) {
        if (phoneNumber == null) {
            return null;
        }
        PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
        try {
            Phonenumber.PhoneNumber numberProto = phoneUtil.parse((CharSequence)phoneNumber, "");
            return String.valueOf(numberProto.getNationalNumber());
        }
        catch (Throwable t) {
            return phoneNumber;
        }
    }

    private static String getShortNameFor(String name) {
        Object result = name;
        if (!StringUtils.isEmpty((String)name)) {
            String[] split = name.split(" ");
            result = split[0] + " " + split[split.length - 1];
        }
        return result;
    }

    private static String getCodeForDocumentType(IDDocumentType idDocumentType) {
        if (idDocumentType != null) {
            switch (idDocumentType) {
                case IDENTITY_CARD: {
                    return "101";
                }
                case PASSPORT: {
                    return "302";
                }
                case FOREIGNER_IDENTITY_CARD: {
                    return "301";
                }
                case NATIVE_COUNTRY_IDENTITY_CARD: {
                    return "301";
                }
                case NAVY_IDENTITY_CARD: {
                    return "203";
                }
                case AIR_FORCE_IDENTITY_CARD: {
                    return "202";
                }
                case OTHER: {
                    return null;
                }
                case MILITARY_IDENTITY_CARD: {
                    return "201";
                }
                case EXTERNAL: {
                    return null;
                }
                case CITIZEN_CARD: {
                    return "801";
                }
                case RESIDENCE_AUTHORIZATION: {
                    return "102";
                }
            }
        }
        return null;
    }

    private static String getCodeForGender(Gender gender) {
        if (gender != null) {
            switch (gender) {
                case MALE: {
                    return "M";
                }
                case FEMALE: {
                    return "F";
                }
            }
            return "X";
        }
        return "X";
    }

    private static String getCodeForMaritalStatus(MaritalStatus maritalStatus) {
        if (maritalStatus == null) {
            maritalStatus = MaritalStatus.UNKNOWN;
        }
        switch (maritalStatus) {
            case SINGLE: {
                return "001";
            }
            case MARRIED: {
                return "009";
            }
            case DIVORCED: {
                return "007";
            }
            case WIDOWER: {
                return "008";
            }
            case SEPARATED: {
                return "006";
            }
            case CIVIL_UNION: {
                return "005";
            }
            case UNKNOWN: {
                return "099";
            }
        }
        return "099";
    }

    private static Student createStudent(Registration registration) {
        Student student = new Student();
        CgdForm43Sender.executeIfAllowed(registration.getPerson(), CgdAuthorizationCodes.BASIC_INFO, () -> {
            student.setSchoolCode(CgdForm43Sender.getInstitutionCode());
            student.setCourse(registration.getDegree().getIdCardName());
            student.setStudentNumber(registration.getStudent().getNumber().intValue());
            student.setAcademicYear(registration.getCurricularYear());
            student.setAcademicDegreeCode(objectFactory.createStudentAcademicDegreeCode(CgdForm43Sender.getCodeForDegreeType(registration.getDegree().getDegreeType()).toString()));
        });
        return student;
    }

    private static Integer getCodeForDegreeType(DegreeType degreeType) {
        Integer BASIC_STUDIES = 1;
        Integer SECUNDARY = 2;
        Integer BACHELHOR = 3;
        Integer DEGREE = 4;
        Integer MASTERS = 5;
        Integer PHD = 6;
        Integer NO_STUDIES = 7;
        Integer OTHER = 99;
        String code = degreeType.getCode();
        if ("BACHELOR".equals(code)) {
            return BACHELHOR;
        }
        if ("DEGREE".equals(code)) {
            return DEGREE;
        }
        if ("MASTER_DEGREE".equals(code)) {
            return MASTERS;
        }
        if ("PHD".equals(code)) {
            return PHD;
        }
        if ("SPECIALIZATION_DEGREE".equals(code)) {
            return OTHER;
        }
        if ("BOLONHA_DEGREE".equals(code)) {
            return DEGREE;
        }
        if ("BOLONHA_MASTER_DEGREE".equals(code)) {
            return MASTERS;
        }
        if ("BOLONHA_INTEGRATED_MASTER_DEGREE".equals(code)) {
            return MASTERS;
        }
        if ("BOLONHA_PHD".equals(code)) {
            return PHD;
        }
        if ("BOLONHA_ADVANCED_FORMATION_DIPLOMA".equals(code)) {
            return OTHER;
        }
        if ("BOLONHA_ADVANCED_SPECIALIZATION_DIPLOMA".equals(code)) {
            return OTHER;
        }
        if ("BOLONHA_SPECIALIZATION_DEGREE".equals(code)) {
            return OTHER;
        }
        if ("FREE_DEGREE".equals(code)) {
            return OTHER;
        }
        if ("BOLONHA_POST_DOCTORAL_DEGREE".equals(code)) {
            return OTHER;
        }
        if ("EMPTY".equals(code)) {
            return NO_STUDIES;
        }
        return DEGREE;
    }

    public String getSchooldIESCode() {
        String institutionCode = CgdForm43Sender.getInstitutionCode();
        IIESService client = (IIESService)this.getClient();
        return CgdForm43Sender.findIES(institutionCode, client);
    }

    private static String findIES(String ministryCode, IIESService service) {
        List<School> schools = service.getSchools().getSchool();
        for (School school : schools) {
            if (!ministryCode.equals(school.getCode().getValue())) continue;
            return (String)school.getPartnerCode().getValue();
        }
        return null;
    }
}

